/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v28.group.EHC_E02_PSG;
import ca.uhn.hl7v2.model.v28.segment.PSS;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class EHC_E02_PRODUCT_SERVICE_SECTION
extends AbstractGroup {
    public EHC_E02_PRODUCT_SERVICE_SECTION(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PSS.class, true, false, true);
            this.add(EHC_E02_PSG.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating EHC_E02_PRODUCT_SERVICE_SECTION - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8";
    }

    public PSS getPSS() {
        PSS retVal = (PSS)this.getTyped("PSS", PSS.class);
        return retVal;
    }

    public EHC_E02_PSG getPSG() {
        EHC_E02_PSG retVal = (EHC_E02_PSG)this.getTyped("PSG", EHC_E02_PSG.class);
        return retVal;
    }

    public EHC_E02_PSG getPSG(int rep) {
        EHC_E02_PSG retVal = (EHC_E02_PSG)this.getTyped("PSG", rep, EHC_E02_PSG.class);
        return retVal;
    }

    public int getPSGReps() {
        return this.getReps("PSG");
    }

    public List<EHC_E02_PSG> getPSGAll() throws HL7Exception {
        return this.getAllAsList("PSG", EHC_E02_PSG.class);
    }

    public void insertPSG(EHC_E02_PSG structure, int rep) throws HL7Exception {
        super.insertRepetition("PSG", (Structure)structure, rep);
    }

    public EHC_E02_PSG insertPSG(int rep) throws HL7Exception {
        return (EHC_E02_PSG)super.insertRepetition("PSG", rep);
    }

    public EHC_E02_PSG removePSG(int rep) throws HL7Exception {
        return (EHC_E02_PSG)super.removeRepetition("PSG", rep);
    }
}

