/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v28.group.OMG_O19_CONTAINER;
import ca.uhn.hl7v2.model.v28.group.OMG_O19_SPECIMEN_OBSERVATION;
import ca.uhn.hl7v2.model.v28.segment.SPM;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class OMG_O19_SPECIMEN
extends AbstractGroup {
    public OMG_O19_SPECIMEN(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SPM.class, true, false, false);
            this.add(OMG_O19_SPECIMEN_OBSERVATION.class, false, true, false);
            this.add(OMG_O19_CONTAINER.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OMG_O19_SPECIMEN - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8";
    }

    public SPM getSPM() {
        SPM retVal = (SPM)this.getTyped("SPM", SPM.class);
        return retVal;
    }

    public OMG_O19_SPECIMEN_OBSERVATION getSPECIMEN_OBSERVATION() {
        OMG_O19_SPECIMEN_OBSERVATION retVal = (OMG_O19_SPECIMEN_OBSERVATION)this.getTyped("SPECIMEN_OBSERVATION", OMG_O19_SPECIMEN_OBSERVATION.class);
        return retVal;
    }

    public OMG_O19_SPECIMEN_OBSERVATION getSPECIMEN_OBSERVATION(int rep) {
        OMG_O19_SPECIMEN_OBSERVATION retVal = (OMG_O19_SPECIMEN_OBSERVATION)this.getTyped("SPECIMEN_OBSERVATION", rep, OMG_O19_SPECIMEN_OBSERVATION.class);
        return retVal;
    }

    public int getSPECIMEN_OBSERVATIONReps() {
        return this.getReps("SPECIMEN_OBSERVATION");
    }

    public List<OMG_O19_SPECIMEN_OBSERVATION> getSPECIMEN_OBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("SPECIMEN_OBSERVATION", OMG_O19_SPECIMEN_OBSERVATION.class);
    }

    public void insertSPECIMEN_OBSERVATION(OMG_O19_SPECIMEN_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("SPECIMEN_OBSERVATION", (Structure)structure, rep);
    }

    public OMG_O19_SPECIMEN_OBSERVATION insertSPECIMEN_OBSERVATION(int rep) throws HL7Exception {
        return (OMG_O19_SPECIMEN_OBSERVATION)super.insertRepetition("SPECIMEN_OBSERVATION", rep);
    }

    public OMG_O19_SPECIMEN_OBSERVATION removeSPECIMEN_OBSERVATION(int rep) throws HL7Exception {
        return (OMG_O19_SPECIMEN_OBSERVATION)super.removeRepetition("SPECIMEN_OBSERVATION", rep);
    }

    public OMG_O19_CONTAINER getCONTAINER() {
        OMG_O19_CONTAINER retVal = (OMG_O19_CONTAINER)this.getTyped("CONTAINER", OMG_O19_CONTAINER.class);
        return retVal;
    }

    public OMG_O19_CONTAINER getCONTAINER(int rep) {
        OMG_O19_CONTAINER retVal = (OMG_O19_CONTAINER)this.getTyped("CONTAINER", rep, OMG_O19_CONTAINER.class);
        return retVal;
    }

    public int getCONTAINERReps() {
        return this.getReps("CONTAINER");
    }

    public List<OMG_O19_CONTAINER> getCONTAINERAll() throws HL7Exception {
        return this.getAllAsList("CONTAINER", OMG_O19_CONTAINER.class);
    }

    public void insertCONTAINER(OMG_O19_CONTAINER structure, int rep) throws HL7Exception {
        super.insertRepetition("CONTAINER", (Structure)structure, rep);
    }

    public OMG_O19_CONTAINER insertCONTAINER(int rep) throws HL7Exception {
        return (OMG_O19_CONTAINER)super.insertRepetition("CONTAINER", rep);
    }

    public OMG_O19_CONTAINER removeCONTAINER(int rep) throws HL7Exception {
        return (OMG_O19_CONTAINER)super.removeRepetition("CONTAINER", rep);
    }
}

