/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v28.group.OPL_O37_OBSERVATION_RESULT_GROUP;
import ca.uhn.hl7v2.model.v28.group.OPL_O37_TIMING;
import ca.uhn.hl7v2.model.v28.segment.OBR;
import ca.uhn.hl7v2.model.v28.segment.ORC;
import ca.uhn.hl7v2.model.v28.segment.PRT;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class OPL_O37_ORDER_PRIOR
extends AbstractGroup {
    public OPL_O37_ORDER_PRIOR(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(OBR.class, true, false, false);
            this.add(ORC.class, false, false, false);
            this.add(PRT.class, false, true, false);
            this.add(OPL_O37_TIMING.class, false, false, false);
            this.add(OPL_O37_OBSERVATION_RESULT_GROUP.class, true, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OPL_O37_ORDER_PRIOR - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8";
    }

    public OBR getOBR() {
        OBR retVal = (OBR)this.getTyped("OBR", OBR.class);
        return retVal;
    }

    public ORC getORC() {
        ORC retVal = (ORC)this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public PRT getPRT() {
        PRT retVal = (PRT)this.getTyped("PRT", PRT.class);
        return retVal;
    }

    public PRT getPRT(int rep) {
        PRT retVal = (PRT)this.getTyped("PRT", rep, PRT.class);
        return retVal;
    }

    public int getPRTReps() {
        return this.getReps("PRT");
    }

    public List<PRT> getPRTAll() throws HL7Exception {
        return this.getAllAsList("PRT", PRT.class);
    }

    public void insertPRT(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT", (Structure)structure, rep);
    }

    public PRT insertPRT(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT", rep);
    }

    public PRT removePRT(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT", rep);
    }

    public OPL_O37_TIMING getTIMING() {
        OPL_O37_TIMING retVal = (OPL_O37_TIMING)this.getTyped("TIMING", OPL_O37_TIMING.class);
        return retVal;
    }

    public OPL_O37_OBSERVATION_RESULT_GROUP getOBSERVATION_RESULT_GROUP() {
        OPL_O37_OBSERVATION_RESULT_GROUP retVal = (OPL_O37_OBSERVATION_RESULT_GROUP)this.getTyped("OBSERVATION_RESULT_GROUP", OPL_O37_OBSERVATION_RESULT_GROUP.class);
        return retVal;
    }

    public OPL_O37_OBSERVATION_RESULT_GROUP getOBSERVATION_RESULT_GROUP(int rep) {
        OPL_O37_OBSERVATION_RESULT_GROUP retVal = (OPL_O37_OBSERVATION_RESULT_GROUP)this.getTyped("OBSERVATION_RESULT_GROUP", rep, OPL_O37_OBSERVATION_RESULT_GROUP.class);
        return retVal;
    }

    public int getOBSERVATION_RESULT_GROUPReps() {
        return this.getReps("OBSERVATION_RESULT_GROUP");
    }

    public List<OPL_O37_OBSERVATION_RESULT_GROUP> getOBSERVATION_RESULT_GROUPAll() throws HL7Exception {
        return this.getAllAsList("OBSERVATION_RESULT_GROUP", OPL_O37_OBSERVATION_RESULT_GROUP.class);
    }

    public void insertOBSERVATION_RESULT_GROUP(OPL_O37_OBSERVATION_RESULT_GROUP structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION_RESULT_GROUP", (Structure)structure, rep);
    }

    public OPL_O37_OBSERVATION_RESULT_GROUP insertOBSERVATION_RESULT_GROUP(int rep) throws HL7Exception {
        return (OPL_O37_OBSERVATION_RESULT_GROUP)super.insertRepetition("OBSERVATION_RESULT_GROUP", rep);
    }

    public OPL_O37_OBSERVATION_RESULT_GROUP removeOBSERVATION_RESULT_GROUP(int rep) throws HL7Exception {
        return (OPL_O37_OBSERVATION_RESULT_GROUP)super.removeRepetition("OBSERVATION_RESULT_GROUP", rep);
    }
}

