/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v28.group.RGV_O15_ENCODING;
import ca.uhn.hl7v2.model.v28.group.RGV_O15_GIVE;
import ca.uhn.hl7v2.model.v28.group.RGV_O15_ORDER_DETAIL;
import ca.uhn.hl7v2.model.v28.group.RGV_O15_TIMING;
import ca.uhn.hl7v2.model.v28.segment.ORC;
import ca.uhn.hl7v2.model.v28.segment.PRT;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class RGV_O15_ORDER
extends AbstractGroup {
    public RGV_O15_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false, false);
            this.add(PRT.class, false, true, false);
            this.add(RGV_O15_TIMING.class, false, true, false);
            this.add(RGV_O15_ORDER_DETAIL.class, false, false, false);
            this.add(RGV_O15_ENCODING.class, false, false, false);
            this.add(RGV_O15_GIVE.class, true, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RGV_O15_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8";
    }

    public ORC getORC() {
        ORC retVal = (ORC)this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public PRT getPRT() {
        PRT retVal = (PRT)this.getTyped("PRT", PRT.class);
        return retVal;
    }

    public PRT getPRT(int rep) {
        PRT retVal = (PRT)this.getTyped("PRT", rep, PRT.class);
        return retVal;
    }

    public int getPRTReps() {
        return this.getReps("PRT");
    }

    public List<PRT> getPRTAll() throws HL7Exception {
        return this.getAllAsList("PRT", PRT.class);
    }

    public void insertPRT(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT", (Structure)structure, rep);
    }

    public PRT insertPRT(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT", rep);
    }

    public PRT removePRT(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT", rep);
    }

    public RGV_O15_TIMING getTIMING() {
        RGV_O15_TIMING retVal = (RGV_O15_TIMING)this.getTyped("TIMING", RGV_O15_TIMING.class);
        return retVal;
    }

    public RGV_O15_TIMING getTIMING(int rep) {
        RGV_O15_TIMING retVal = (RGV_O15_TIMING)this.getTyped("TIMING", rep, RGV_O15_TIMING.class);
        return retVal;
    }

    public int getTIMINGReps() {
        return this.getReps("TIMING");
    }

    public List<RGV_O15_TIMING> getTIMINGAll() throws HL7Exception {
        return this.getAllAsList("TIMING", RGV_O15_TIMING.class);
    }

    public void insertTIMING(RGV_O15_TIMING structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING", (Structure)structure, rep);
    }

    public RGV_O15_TIMING insertTIMING(int rep) throws HL7Exception {
        return (RGV_O15_TIMING)super.insertRepetition("TIMING", rep);
    }

    public RGV_O15_TIMING removeTIMING(int rep) throws HL7Exception {
        return (RGV_O15_TIMING)super.removeRepetition("TIMING", rep);
    }

    public RGV_O15_ORDER_DETAIL getORDER_DETAIL() {
        RGV_O15_ORDER_DETAIL retVal = (RGV_O15_ORDER_DETAIL)this.getTyped("ORDER_DETAIL", RGV_O15_ORDER_DETAIL.class);
        return retVal;
    }

    public RGV_O15_ENCODING getENCODING() {
        RGV_O15_ENCODING retVal = (RGV_O15_ENCODING)this.getTyped("ENCODING", RGV_O15_ENCODING.class);
        return retVal;
    }

    public RGV_O15_GIVE getGIVE() {
        RGV_O15_GIVE retVal = (RGV_O15_GIVE)this.getTyped("GIVE", RGV_O15_GIVE.class);
        return retVal;
    }

    public RGV_O15_GIVE getGIVE(int rep) {
        RGV_O15_GIVE retVal = (RGV_O15_GIVE)this.getTyped("GIVE", rep, RGV_O15_GIVE.class);
        return retVal;
    }

    public int getGIVEReps() {
        return this.getReps("GIVE");
    }

    public List<RGV_O15_GIVE> getGIVEAll() throws HL7Exception {
        return this.getAllAsList("GIVE", RGV_O15_GIVE.class);
    }

    public void insertGIVE(RGV_O15_GIVE structure, int rep) throws HL7Exception {
        super.insertRepetition("GIVE", (Structure)structure, rep);
    }

    public RGV_O15_GIVE insertGIVE(int rep) throws HL7Exception {
        return (RGV_O15_GIVE)super.insertRepetition("GIVE", rep);
    }

    public RGV_O15_GIVE removeGIVE(int rep) throws HL7Exception {
        return (RGV_O15_GIVE)super.removeRepetition("GIVE", rep);
    }
}

