/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v28.group.RRA_O18_ADMINISTRATION;
import ca.uhn.hl7v2.model.v28.group.RRA_O18_TIMING;
import ca.uhn.hl7v2.model.v28.segment.ORC;
import ca.uhn.hl7v2.model.v28.segment.PRT;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class RRA_O18_ORDER
extends AbstractGroup {
    public RRA_O18_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false, false);
            this.add(PRT.class, false, true, false);
            this.add(RRA_O18_TIMING.class, false, true, false);
            this.add(RRA_O18_ADMINISTRATION.class, false, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RRA_O18_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8";
    }

    public ORC getORC() {
        ORC retVal = (ORC)this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public PRT getPRT() {
        PRT retVal = (PRT)this.getTyped("PRT", PRT.class);
        return retVal;
    }

    public PRT getPRT(int rep) {
        PRT retVal = (PRT)this.getTyped("PRT", rep, PRT.class);
        return retVal;
    }

    public int getPRTReps() {
        return this.getReps("PRT");
    }

    public List<PRT> getPRTAll() throws HL7Exception {
        return this.getAllAsList("PRT", PRT.class);
    }

    public void insertPRT(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT", (Structure)structure, rep);
    }

    public PRT insertPRT(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT", rep);
    }

    public PRT removePRT(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT", rep);
    }

    public RRA_O18_TIMING getTIMING() {
        RRA_O18_TIMING retVal = (RRA_O18_TIMING)this.getTyped("TIMING", RRA_O18_TIMING.class);
        return retVal;
    }

    public RRA_O18_TIMING getTIMING(int rep) {
        RRA_O18_TIMING retVal = (RRA_O18_TIMING)this.getTyped("TIMING", rep, RRA_O18_TIMING.class);
        return retVal;
    }

    public int getTIMINGReps() {
        return this.getReps("TIMING");
    }

    public List<RRA_O18_TIMING> getTIMINGAll() throws HL7Exception {
        return this.getAllAsList("TIMING", RRA_O18_TIMING.class);
    }

    public void insertTIMING(RRA_O18_TIMING structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING", (Structure)structure, rep);
    }

    public RRA_O18_TIMING insertTIMING(int rep) throws HL7Exception {
        return (RRA_O18_TIMING)super.insertRepetition("TIMING", rep);
    }

    public RRA_O18_TIMING removeTIMING(int rep) throws HL7Exception {
        return (RRA_O18_TIMING)super.removeRepetition("TIMING", rep);
    }

    public RRA_O18_ADMINISTRATION getADMINISTRATION() {
        RRA_O18_ADMINISTRATION retVal = (RRA_O18_ADMINISTRATION)this.getTyped("ADMINISTRATION", RRA_O18_ADMINISTRATION.class);
        return retVal;
    }
}

