/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v28.group.MFN_M11_MF_TEST_CALCULATED;
import ca.uhn.hl7v2.model.v28.segment.MFI;
import ca.uhn.hl7v2.model.v28.segment.MSH;
import ca.uhn.hl7v2.model.v28.segment.SFT;
import ca.uhn.hl7v2.model.v28.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class MFN_M11
extends AbstractMessage {
    public MFN_M11() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public MFN_M11(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(MFI.class, true, false);
            this.add(MFN_M11_MF_TEST_CALCULATED.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MFN_M11 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return (UAC)this.getTyped("UAC", UAC.class);
    }

    public MFI getMFI() {
        return (MFI)this.getTyped("MFI", MFI.class);
    }

    public MFN_M11_MF_TEST_CALCULATED getMF_TEST_CALCULATED() {
        return (MFN_M11_MF_TEST_CALCULATED)this.getTyped("MF_TEST_CALCULATED", MFN_M11_MF_TEST_CALCULATED.class);
    }

    public MFN_M11_MF_TEST_CALCULATED getMF_TEST_CALCULATED(int rep) {
        return (MFN_M11_MF_TEST_CALCULATED)this.getTyped("MF_TEST_CALCULATED", rep, MFN_M11_MF_TEST_CALCULATED.class);
    }

    public int getMF_TEST_CALCULATEDReps() {
        return this.getReps("MF_TEST_CALCULATED");
    }

    public List<MFN_M11_MF_TEST_CALCULATED> getMF_TEST_CALCULATEDAll() throws HL7Exception {
        return this.getAllAsList("MF_TEST_CALCULATED", MFN_M11_MF_TEST_CALCULATED.class);
    }

    public void insertMF_TEST_CALCULATED(MFN_M11_MF_TEST_CALCULATED structure, int rep) throws HL7Exception {
        super.insertRepetition("MF_TEST_CALCULATED", (Structure)structure, rep);
    }

    public MFN_M11_MF_TEST_CALCULATED insertMF_TEST_CALCULATED(int rep) throws HL7Exception {
        return (MFN_M11_MF_TEST_CALCULATED)super.insertRepetition("MF_TEST_CALCULATED", rep);
    }

    public MFN_M11_MF_TEST_CALCULATED removeMF_TEST_CALCULATED(int rep) throws HL7Exception {
        return (MFN_M11_MF_TEST_CALCULATED)super.removeRepetition("MF_TEST_CALCULATED", rep);
    }
}

