/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v28.datatype.CNE;
import ca.uhn.hl7v2.model.v28.datatype.CP;
import ca.uhn.hl7v2.model.v28.datatype.CWE;
import ca.uhn.hl7v2.model.v28.datatype.DTM;
import ca.uhn.hl7v2.model.v28.datatype.ID;
import ca.uhn.hl7v2.model.v28.datatype.MO;
import ca.uhn.hl7v2.model.v28.datatype.NM;
import ca.uhn.hl7v2.model.v28.datatype.ST;
import ca.uhn.hl7v2.model.v28.datatype.XPN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class DRG
extends AbstractSegment {
    public DRG(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CNE.class, false, 1, 0, new Object[]{this.getMessage()}, "Diagnostic Related Group");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "DRG Assigned Date/Time");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "DRG Approval Indicator");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "DRG Grouper Review Code");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Outlier Type");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Outlier Days");
            this.add(CP.class, false, 1, 0, new Object[]{this.getMessage()}, "Outlier Cost");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "DRG Payor");
            this.add(CP.class, false, 1, 0, new Object[]{this.getMessage()}, "Outlier Reimbursement");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Confidential Indicator");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "DRG Transfer Type");
            this.add(XPN.class, false, 1, 0, new Object[]{this.getMessage()}, "Name of Coder");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Grouper Status");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "PCCL Value Code");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Effective Weight");
            this.add(MO.class, false, 1, 0, new Object[]{this.getMessage()}, "Monetary Amount");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Status Patient");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Grouper Software Name");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Grouper Software Version");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Status Financial Calculation");
            this.add(MO.class, false, 1, 0, new Object[]{this.getMessage()}, "Relative Discount/Surcharge");
            this.add(MO.class, false, 1, 0, new Object[]{this.getMessage()}, "Basic Charge");
            this.add(MO.class, false, 1, 0, new Object[]{this.getMessage()}, "Total Charge");
            this.add(MO.class, false, 1, 0, new Object[]{this.getMessage()}, "Discount/Surcharge");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Calculated Days");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Status Gender");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Status Age");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Status Length of Stay");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Status Same Day Flag");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Status Separation Mode");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Status Weight at Birth");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Status Respiration Minutes");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Status Admission");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating DRG - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CNE getDiagnosticRelatedGroup() {
        CNE retVal = (CNE)this.getTypedField(1, 0);
        return retVal;
    }

    public CNE getDrg1_DiagnosticRelatedGroup() {
        CNE retVal = (CNE)this.getTypedField(1, 0);
        return retVal;
    }

    public DTM getDRGAssignedDateTime() {
        DTM retVal = (DTM)this.getTypedField(2, 0);
        return retVal;
    }

    public DTM getDrg2_DRGAssignedDateTime() {
        DTM retVal = (DTM)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getDRGApprovalIndicator() {
        ID retVal = (ID)this.getTypedField(3, 0);
        return retVal;
    }

    public ID getDrg3_DRGApprovalIndicator() {
        ID retVal = (ID)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getDRGGrouperReviewCode() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getDrg4_DRGGrouperReviewCode() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getOutlierType() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getDrg5_OutlierType() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public NM getOutlierDays() {
        NM retVal = (NM)this.getTypedField(6, 0);
        return retVal;
    }

    public NM getDrg6_OutlierDays() {
        NM retVal = (NM)this.getTypedField(6, 0);
        return retVal;
    }

    public CP getOutlierCost() {
        CP retVal = (CP)this.getTypedField(7, 0);
        return retVal;
    }

    public CP getDrg7_OutlierCost() {
        CP retVal = (CP)this.getTypedField(7, 0);
        return retVal;
    }

    public CWE getDRGPayor() {
        CWE retVal = (CWE)this.getTypedField(8, 0);
        return retVal;
    }

    public CWE getDrg8_DRGPayor() {
        CWE retVal = (CWE)this.getTypedField(8, 0);
        return retVal;
    }

    public CP getOutlierReimbursement() {
        CP retVal = (CP)this.getTypedField(9, 0);
        return retVal;
    }

    public CP getDrg9_OutlierReimbursement() {
        CP retVal = (CP)this.getTypedField(9, 0);
        return retVal;
    }

    public ID getConfidentialIndicator() {
        ID retVal = (ID)this.getTypedField(10, 0);
        return retVal;
    }

    public ID getDrg10_ConfidentialIndicator() {
        ID retVal = (ID)this.getTypedField(10, 0);
        return retVal;
    }

    public CWE getDRGTransferType() {
        CWE retVal = (CWE)this.getTypedField(11, 0);
        return retVal;
    }

    public CWE getDrg11_DRGTransferType() {
        CWE retVal = (CWE)this.getTypedField(11, 0);
        return retVal;
    }

    public XPN getNameOfCoder() {
        XPN retVal = (XPN)this.getTypedField(12, 0);
        return retVal;
    }

    public XPN getDrg12_NameOfCoder() {
        XPN retVal = (XPN)this.getTypedField(12, 0);
        return retVal;
    }

    public CWE getGrouperStatus() {
        CWE retVal = (CWE)this.getTypedField(13, 0);
        return retVal;
    }

    public CWE getDrg13_GrouperStatus() {
        CWE retVal = (CWE)this.getTypedField(13, 0);
        return retVal;
    }

    public CWE getPCCLValueCode() {
        CWE retVal = (CWE)this.getTypedField(14, 0);
        return retVal;
    }

    public CWE getDrg14_PCCLValueCode() {
        CWE retVal = (CWE)this.getTypedField(14, 0);
        return retVal;
    }

    public NM getEffectiveWeight() {
        NM retVal = (NM)this.getTypedField(15, 0);
        return retVal;
    }

    public NM getDrg15_EffectiveWeight() {
        NM retVal = (NM)this.getTypedField(15, 0);
        return retVal;
    }

    public MO getMonetaryAmount() {
        MO retVal = (MO)this.getTypedField(16, 0);
        return retVal;
    }

    public MO getDrg16_MonetaryAmount() {
        MO retVal = (MO)this.getTypedField(16, 0);
        return retVal;
    }

    public CWE getStatusPatient() {
        CWE retVal = (CWE)this.getTypedField(17, 0);
        return retVal;
    }

    public CWE getDrg17_StatusPatient() {
        CWE retVal = (CWE)this.getTypedField(17, 0);
        return retVal;
    }

    public ST getGrouperSoftwareName() {
        ST retVal = (ST)this.getTypedField(18, 0);
        return retVal;
    }

    public ST getDrg18_GrouperSoftwareName() {
        ST retVal = (ST)this.getTypedField(18, 0);
        return retVal;
    }

    public ST getGrouperSoftwareVersion() {
        ST retVal = (ST)this.getTypedField(19, 0);
        return retVal;
    }

    public ST getDrg19_GrouperSoftwareVersion() {
        ST retVal = (ST)this.getTypedField(19, 0);
        return retVal;
    }

    public CWE getStatusFinancialCalculation() {
        CWE retVal = (CWE)this.getTypedField(20, 0);
        return retVal;
    }

    public CWE getDrg20_StatusFinancialCalculation() {
        CWE retVal = (CWE)this.getTypedField(20, 0);
        return retVal;
    }

    public MO getRelativeDiscountSurcharge() {
        MO retVal = (MO)this.getTypedField(21, 0);
        return retVal;
    }

    public MO getDrg21_RelativeDiscountSurcharge() {
        MO retVal = (MO)this.getTypedField(21, 0);
        return retVal;
    }

    public MO getBasicCharge() {
        MO retVal = (MO)this.getTypedField(22, 0);
        return retVal;
    }

    public MO getDrg22_BasicCharge() {
        MO retVal = (MO)this.getTypedField(22, 0);
        return retVal;
    }

    public MO getTotalCharge() {
        MO retVal = (MO)this.getTypedField(23, 0);
        return retVal;
    }

    public MO getDrg23_TotalCharge() {
        MO retVal = (MO)this.getTypedField(23, 0);
        return retVal;
    }

    public MO getDiscountSurcharge() {
        MO retVal = (MO)this.getTypedField(24, 0);
        return retVal;
    }

    public MO getDrg24_DiscountSurcharge() {
        MO retVal = (MO)this.getTypedField(24, 0);
        return retVal;
    }

    public NM getCalculatedDays() {
        NM retVal = (NM)this.getTypedField(25, 0);
        return retVal;
    }

    public NM getDrg25_CalculatedDays() {
        NM retVal = (NM)this.getTypedField(25, 0);
        return retVal;
    }

    public CWE getStatusGender() {
        CWE retVal = (CWE)this.getTypedField(26, 0);
        return retVal;
    }

    public CWE getDrg26_StatusGender() {
        CWE retVal = (CWE)this.getTypedField(26, 0);
        return retVal;
    }

    public CWE getStatusAge() {
        CWE retVal = (CWE)this.getTypedField(27, 0);
        return retVal;
    }

    public CWE getDrg27_StatusAge() {
        CWE retVal = (CWE)this.getTypedField(27, 0);
        return retVal;
    }

    public CWE getStatusLengthOfStay() {
        CWE retVal = (CWE)this.getTypedField(28, 0);
        return retVal;
    }

    public CWE getDrg28_StatusLengthOfStay() {
        CWE retVal = (CWE)this.getTypedField(28, 0);
        return retVal;
    }

    public CWE getStatusSameDayFlag() {
        CWE retVal = (CWE)this.getTypedField(29, 0);
        return retVal;
    }

    public CWE getDrg29_StatusSameDayFlag() {
        CWE retVal = (CWE)this.getTypedField(29, 0);
        return retVal;
    }

    public CWE getStatusSeparationMode() {
        CWE retVal = (CWE)this.getTypedField(30, 0);
        return retVal;
    }

    public CWE getDrg30_StatusSeparationMode() {
        CWE retVal = (CWE)this.getTypedField(30, 0);
        return retVal;
    }

    public CWE getStatusWeightAtBirth() {
        CWE retVal = (CWE)this.getTypedField(31, 0);
        return retVal;
    }

    public CWE getDrg31_StatusWeightAtBirth() {
        CWE retVal = (CWE)this.getTypedField(31, 0);
        return retVal;
    }

    public CWE getStatusRespirationMinutes() {
        CWE retVal = (CWE)this.getTypedField(32, 0);
        return retVal;
    }

    public CWE getDrg32_StatusRespirationMinutes() {
        CWE retVal = (CWE)this.getTypedField(32, 0);
        return retVal;
    }

    public CWE getStatusAdmission() {
        CWE retVal = (CWE)this.getTypedField(33, 0);
        return retVal;
    }

    public CWE getDrg33_StatusAdmission() {
        CWE retVal = (CWE)this.getTypedField(33, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CNE(this.getMessage());
            }
            case 1: {
                return new DTM(this.getMessage());
            }
            case 2: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 3: {
                return new CWE(this.getMessage());
            }
            case 4: {
                return new CWE(this.getMessage());
            }
            case 5: {
                return new NM(this.getMessage());
            }
            case 6: {
                return new CP(this.getMessage());
            }
            case 7: {
                return new CWE(this.getMessage());
            }
            case 8: {
                return new CP(this.getMessage());
            }
            case 9: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 10: {
                return new CWE(this.getMessage());
            }
            case 11: {
                return new XPN(this.getMessage());
            }
            case 12: {
                return new CWE(this.getMessage());
            }
            case 13: {
                return new CWE(this.getMessage());
            }
            case 14: {
                return new NM(this.getMessage());
            }
            case 15: {
                return new MO(this.getMessage());
            }
            case 16: {
                return new CWE(this.getMessage());
            }
            case 17: {
                return new ST(this.getMessage());
            }
            case 18: {
                return new ST(this.getMessage());
            }
            case 19: {
                return new CWE(this.getMessage());
            }
            case 20: {
                return new MO(this.getMessage());
            }
            case 21: {
                return new MO(this.getMessage());
            }
            case 22: {
                return new MO(this.getMessage());
            }
            case 23: {
                return new MO(this.getMessage());
            }
            case 24: {
                return new NM(this.getMessage());
            }
            case 25: {
                return new CWE(this.getMessage());
            }
            case 26: {
                return new CWE(this.getMessage());
            }
            case 27: {
                return new CWE(this.getMessage());
            }
            case 28: {
                return new CWE(this.getMessage());
            }
            case 29: {
                return new CWE(this.getMessage());
            }
            case 30: {
                return new CWE(this.getMessage());
            }
            case 31: {
                return new CWE(this.getMessage());
            }
            case 32: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

