/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v28.datatype.CWE;
import ca.uhn.hl7v2.model.v28.datatype.PL;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class LCC
extends AbstractSegment {
    public LCC(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PL.class, true, 1, 0, new Object[]{this.getMessage()}, "Primary Key Value - LCC");
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "Location Department");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Accommodation Type");
            this.add(CWE.class, true, 0, 0, new Object[]{this.getMessage()}, "Charge Code");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating LCC - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public PL getPrimaryKeyValueLCC() {
        PL retVal = (PL)this.getTypedField(1, 0);
        return retVal;
    }

    public PL getLcc1_PrimaryKeyValueLCC() {
        PL retVal = (PL)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getLocationDepartment() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getLcc2_LocationDepartment() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE[] getAccommodationType() {
        CWE[] retVal = (CWE[])this.getTypedField(3, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getLcc3_AccommodationType() {
        CWE[] retVal = (CWE[])this.getTypedField(3, (Type[])new CWE[0]);
        return retVal;
    }

    public int getAccommodationTypeReps() {
        return this.getReps(3);
    }

    public CWE getAccommodationType(int rep) {
        CWE retVal = (CWE)this.getTypedField(3, rep);
        return retVal;
    }

    public CWE getLcc3_AccommodationType(int rep) {
        CWE retVal = (CWE)this.getTypedField(3, rep);
        return retVal;
    }

    public int getLcc3_AccommodationTypeReps() {
        return this.getReps(3);
    }

    public CWE insertAccommodationType(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(3, rep);
    }

    public CWE insertLcc3_AccommodationType(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(3, rep);
    }

    public CWE removeAccommodationType(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(3, rep);
    }

    public CWE removeLcc3_AccommodationType(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(3, rep);
    }

    public CWE[] getChargeCode() {
        CWE[] retVal = (CWE[])this.getTypedField(4, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getLcc4_ChargeCode() {
        CWE[] retVal = (CWE[])this.getTypedField(4, (Type[])new CWE[0]);
        return retVal;
    }

    public int getChargeCodeReps() {
        return this.getReps(4);
    }

    public CWE getChargeCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(4, rep);
        return retVal;
    }

    public CWE getLcc4_ChargeCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(4, rep);
        return retVal;
    }

    public int getLcc4_ChargeCodeReps() {
        return this.getReps(4);
    }

    public CWE insertChargeCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(4, rep);
    }

    public CWE insertLcc4_ChargeCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(4, rep);
    }

    public CWE removeChargeCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(4, rep);
    }

    public CWE removeLcc4_ChargeCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(4, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new PL(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

