/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v28.datatype.CWE;
import ca.uhn.hl7v2.model.v28.datatype.DTM;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class RMI
extends AbstractSegment {
    public RMI(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Risk Management Incident Code");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Date/Time Incident");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Incident Type Code");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RMI - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CWE getRiskManagementIncidentCode() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getRmi1_RiskManagementIncidentCode() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public DTM getDateTimeIncident() {
        DTM retVal = (DTM)this.getTypedField(2, 0);
        return retVal;
    }

    public DTM getRmi2_DateTimeIncident() {
        DTM retVal = (DTM)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getIncidentTypeCode() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getRmi3_IncidentTypeCode() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CWE(this.getMessage());
            }
            case 1: {
                return new DTM(this.getMessage());
            }
            case 2: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

