/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v28.datatype.CWE;
import ca.uhn.hl7v2.model.v28.datatype.DTM;
import ca.uhn.hl7v2.model.v28.datatype.FN;
import ca.uhn.hl7v2.model.v28.datatype.HD;
import ca.uhn.hl7v2.model.v28.datatype.ID;
import ca.uhn.hl7v2.model.v28.datatype.ST;

public class PPN
extends AbstractComposite {
    private Type[] data;

    public PPN(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[26];
        this.data[0] = new ST(this.getMessage());
        this.data[1] = new FN(this.getMessage());
        this.data[2] = new ST(this.getMessage());
        this.data[3] = new ST(this.getMessage());
        this.data[4] = new ST(this.getMessage());
        this.data[5] = new ST(this.getMessage());
        this.data[6] = new ST(this.getMessage());
        this.data[7] = new CWE(this.getMessage());
        this.data[8] = new HD(this.getMessage());
        this.data[9] = new ID(this.getMessage(), 200);
        this.data[10] = new ST(this.getMessage());
        this.data[11] = new ID(this.getMessage(), 61);
        this.data[12] = new ID(this.getMessage(), 203);
        this.data[13] = new HD(this.getMessage());
        this.data[14] = new DTM(this.getMessage());
        this.data[15] = new ID(this.getMessage(), 465);
        this.data[16] = new CWE(this.getMessage());
        this.data[17] = new ST(this.getMessage());
        this.data[18] = new ID(this.getMessage(), 444);
        this.data[19] = new DTM(this.getMessage());
        this.data[20] = new DTM(this.getMessage());
        this.data[21] = new ST(this.getMessage());
        this.data[22] = new CWE(this.getMessage());
        this.data[23] = new CWE(this.getMessage());
        this.data[24] = new ST(this.getMessage());
        this.data[25] = new ID(this.getMessage(), 904);
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + ((Object)((Object)this)).getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public ST getPersonIdentifier() {
        return (ST)this.getTyped(0, ST.class);
    }

    public ST getPpn1_PersonIdentifier() {
        return (ST)this.getTyped(0, ST.class);
    }

    public FN getFamilyName() {
        return (FN)this.getTyped(1, FN.class);
    }

    public FN getPpn2_FamilyName() {
        return (FN)this.getTyped(1, FN.class);
    }

    public ST getGivenName() {
        return (ST)this.getTyped(2, ST.class);
    }

    public ST getPpn3_GivenName() {
        return (ST)this.getTyped(2, ST.class);
    }

    public ST getSecondAndFurtherGivenNamesOrInitialsThereof() {
        return (ST)this.getTyped(3, ST.class);
    }

    public ST getPpn4_SecondAndFurtherGivenNamesOrInitialsThereof() {
        return (ST)this.getTyped(3, ST.class);
    }

    public ST getSuffixEgJRorIII() {
        return (ST)this.getTyped(4, ST.class);
    }

    public ST getPpn5_SuffixEgJRorIII() {
        return (ST)this.getTyped(4, ST.class);
    }

    public ST getPrefixEgDR() {
        return (ST)this.getTyped(5, ST.class);
    }

    public ST getPpn6_PrefixEgDR() {
        return (ST)this.getTyped(5, ST.class);
    }

    public ST getDegreeEgMD() {
        return (ST)this.getTyped(6, ST.class);
    }

    public ST getPpn7_DegreeEgMD() {
        return (ST)this.getTyped(6, ST.class);
    }

    public CWE getSourceTable() {
        return (CWE)this.getTyped(7, CWE.class);
    }

    public CWE getPpn8_SourceTable() {
        return (CWE)this.getTyped(7, CWE.class);
    }

    public HD getAssigningAuthority() {
        return (HD)this.getTyped(8, HD.class);
    }

    public HD getPpn9_AssigningAuthority() {
        return (HD)this.getTyped(8, HD.class);
    }

    public ID getNameTypeCode() {
        return (ID)this.getTyped(9, ID.class);
    }

    public ID getPpn10_NameTypeCode() {
        return (ID)this.getTyped(9, ID.class);
    }

    public ST getIdentifierCheckDigit() {
        return (ST)this.getTyped(10, ST.class);
    }

    public ST getPpn11_IdentifierCheckDigit() {
        return (ST)this.getTyped(10, ST.class);
    }

    public ID getCheckDigitScheme() {
        return (ID)this.getTyped(11, ID.class);
    }

    public ID getPpn12_CheckDigitScheme() {
        return (ID)this.getTyped(11, ID.class);
    }

    public ID getIdentifierTypeCode() {
        return (ID)this.getTyped(12, ID.class);
    }

    public ID getPpn13_IdentifierTypeCode() {
        return (ID)this.getTyped(12, ID.class);
    }

    public HD getAssigningFacility() {
        return (HD)this.getTyped(13, HD.class);
    }

    public HD getPpn14_AssigningFacility() {
        return (HD)this.getTyped(13, HD.class);
    }

    public DTM getDateTimeActionPerformed() {
        return (DTM)this.getTyped(14, DTM.class);
    }

    public DTM getPpn15_DateTimeActionPerformed() {
        return (DTM)this.getTyped(14, DTM.class);
    }

    public ID getNameRepresentationCode() {
        return (ID)this.getTyped(15, ID.class);
    }

    public ID getPpn16_NameRepresentationCode() {
        return (ID)this.getTyped(15, ID.class);
    }

    public CWE getNameContext() {
        return (CWE)this.getTyped(16, CWE.class);
    }

    public CWE getPpn17_NameContext() {
        return (CWE)this.getTyped(16, CWE.class);
    }

    public ST getNameValidityRange() {
        return (ST)this.getTyped(17, ST.class);
    }

    public ST getPpn18_NameValidityRange() {
        return (ST)this.getTyped(17, ST.class);
    }

    public ID getNameAssemblyOrder() {
        return (ID)this.getTyped(18, ID.class);
    }

    public ID getPpn19_NameAssemblyOrder() {
        return (ID)this.getTyped(18, ID.class);
    }

    public DTM getEffectiveDate() {
        return (DTM)this.getTyped(19, DTM.class);
    }

    public DTM getPpn20_EffectiveDate() {
        return (DTM)this.getTyped(19, DTM.class);
    }

    public DTM getExpirationDate() {
        return (DTM)this.getTyped(20, DTM.class);
    }

    public DTM getPpn21_ExpirationDate() {
        return (DTM)this.getTyped(20, DTM.class);
    }

    public ST getProfessionalSuffix() {
        return (ST)this.getTyped(21, ST.class);
    }

    public ST getPpn22_ProfessionalSuffix() {
        return (ST)this.getTyped(21, ST.class);
    }

    public CWE getAssigningJurisdiction() {
        return (CWE)this.getTyped(22, CWE.class);
    }

    public CWE getPpn23_AssigningJurisdiction() {
        return (CWE)this.getTyped(22, CWE.class);
    }

    public CWE getAssigningAgencyOrDepartment() {
        return (CWE)this.getTyped(23, CWE.class);
    }

    public CWE getPpn24_AssigningAgencyOrDepartment() {
        return (CWE)this.getTyped(23, CWE.class);
    }

    public ST getSecurityCheck() {
        return (ST)this.getTyped(24, ST.class);
    }

    public ST getPpn25_SecurityCheck() {
        return (ST)this.getTyped(24, ST.class);
    }

    public ID getSecurityCheckScheme() {
        return (ID)this.getTyped(25, ID.class);
    }

    public ID getPpn26_SecurityCheckScheme() {
        return (ID)this.getTyped(25, ID.class);
    }
}

