/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v28.group.CCU_I20_MEDICATION_ADMINISTRATION_DETAIL;
import ca.uhn.hl7v2.model.v28.group.CCU_I20_MEDICATION_ENCODING_DETAIL;
import ca.uhn.hl7v2.model.v28.group.CCU_I20_MEDICATION_ORDER_DETAIL;
import ca.uhn.hl7v2.model.v28.segment.CTI;
import ca.uhn.hl7v2.model.v28.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class CCU_I20_MEDICATION_HISTORY
extends AbstractGroup {
    public CCU_I20_MEDICATION_HISTORY(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false, false);
            this.add(CCU_I20_MEDICATION_ORDER_DETAIL.class, false, false, false);
            this.add(CCU_I20_MEDICATION_ENCODING_DETAIL.class, false, false, false);
            this.add(CCU_I20_MEDICATION_ADMINISTRATION_DETAIL.class, false, true, false);
            this.add(CTI.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating CCU_I20_MEDICATION_HISTORY - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8";
    }

    public ORC getORC() {
        ORC retVal = (ORC)this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public CCU_I20_MEDICATION_ORDER_DETAIL getMEDICATION_ORDER_DETAIL() {
        CCU_I20_MEDICATION_ORDER_DETAIL retVal = (CCU_I20_MEDICATION_ORDER_DETAIL)this.getTyped("MEDICATION_ORDER_DETAIL", CCU_I20_MEDICATION_ORDER_DETAIL.class);
        return retVal;
    }

    public CCU_I20_MEDICATION_ENCODING_DETAIL getMEDICATION_ENCODING_DETAIL() {
        CCU_I20_MEDICATION_ENCODING_DETAIL retVal = (CCU_I20_MEDICATION_ENCODING_DETAIL)this.getTyped("MEDICATION_ENCODING_DETAIL", CCU_I20_MEDICATION_ENCODING_DETAIL.class);
        return retVal;
    }

    public CCU_I20_MEDICATION_ADMINISTRATION_DETAIL getMEDICATION_ADMINISTRATION_DETAIL() {
        CCU_I20_MEDICATION_ADMINISTRATION_DETAIL retVal = (CCU_I20_MEDICATION_ADMINISTRATION_DETAIL)this.getTyped("MEDICATION_ADMINISTRATION_DETAIL", CCU_I20_MEDICATION_ADMINISTRATION_DETAIL.class);
        return retVal;
    }

    public CCU_I20_MEDICATION_ADMINISTRATION_DETAIL getMEDICATION_ADMINISTRATION_DETAIL(int rep) {
        CCU_I20_MEDICATION_ADMINISTRATION_DETAIL retVal = (CCU_I20_MEDICATION_ADMINISTRATION_DETAIL)this.getTyped("MEDICATION_ADMINISTRATION_DETAIL", rep, CCU_I20_MEDICATION_ADMINISTRATION_DETAIL.class);
        return retVal;
    }

    public int getMEDICATION_ADMINISTRATION_DETAILReps() {
        return this.getReps("MEDICATION_ADMINISTRATION_DETAIL");
    }

    public List<CCU_I20_MEDICATION_ADMINISTRATION_DETAIL> getMEDICATION_ADMINISTRATION_DETAILAll() throws HL7Exception {
        return this.getAllAsList("MEDICATION_ADMINISTRATION_DETAIL", CCU_I20_MEDICATION_ADMINISTRATION_DETAIL.class);
    }

    public void insertMEDICATION_ADMINISTRATION_DETAIL(CCU_I20_MEDICATION_ADMINISTRATION_DETAIL structure, int rep) throws HL7Exception {
        super.insertRepetition("MEDICATION_ADMINISTRATION_DETAIL", (Structure)structure, rep);
    }

    public CCU_I20_MEDICATION_ADMINISTRATION_DETAIL insertMEDICATION_ADMINISTRATION_DETAIL(int rep) throws HL7Exception {
        return (CCU_I20_MEDICATION_ADMINISTRATION_DETAIL)super.insertRepetition("MEDICATION_ADMINISTRATION_DETAIL", rep);
    }

    public CCU_I20_MEDICATION_ADMINISTRATION_DETAIL removeMEDICATION_ADMINISTRATION_DETAIL(int rep) throws HL7Exception {
        return (CCU_I20_MEDICATION_ADMINISTRATION_DETAIL)super.removeRepetition("MEDICATION_ADMINISTRATION_DETAIL", rep);
    }

    public CTI getCTI() {
        CTI retVal = (CTI)this.getTyped("CTI", CTI.class);
        return retVal;
    }

    public CTI getCTI(int rep) {
        CTI retVal = (CTI)this.getTyped("CTI", rep, CTI.class);
        return retVal;
    }

    public int getCTIReps() {
        return this.getReps("CTI");
    }

    public List<CTI> getCTIAll() throws HL7Exception {
        return this.getAllAsList("CTI", CTI.class);
    }

    public void insertCTI(CTI structure, int rep) throws HL7Exception {
        super.insertRepetition("CTI", (Structure)structure, rep);
    }

    public CTI insertCTI(int rep) throws HL7Exception {
        return (CTI)super.insertRepetition("CTI", rep);
    }

    public CTI removeCTI(int rep) throws HL7Exception {
        return (CTI)super.removeRepetition("CTI", rep);
    }
}

