/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v28.group.CSU_C09_STUDY_OBSERVATION_ORDER;
import ca.uhn.hl7v2.model.v28.group.CSU_C09_TIMING_QTY;
import ca.uhn.hl7v2.model.v28.segment.OBR;
import ca.uhn.hl7v2.model.v28.segment.OBX;
import ca.uhn.hl7v2.model.v28.segment.PRT;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class CSU_C09_STUDY_OBSERVATION
extends AbstractGroup {
    public CSU_C09_STUDY_OBSERVATION(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CSU_C09_STUDY_OBSERVATION_ORDER.class, false, false, false);
            this.add(OBR.class, true, false, false);
            this.add(PRT.class, false, true, false);
            this.add(CSU_C09_TIMING_QTY.class, false, true, false);
            this.add(OBX.class, true, false, false);
            this.add(PRT.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating CSU_C09_STUDY_OBSERVATION - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8";
    }

    public CSU_C09_STUDY_OBSERVATION_ORDER getSTUDY_OBSERVATION_ORDER() {
        CSU_C09_STUDY_OBSERVATION_ORDER retVal = (CSU_C09_STUDY_OBSERVATION_ORDER)this.getTyped("STUDY_OBSERVATION_ORDER", CSU_C09_STUDY_OBSERVATION_ORDER.class);
        return retVal;
    }

    public OBR getOBR() {
        OBR retVal = (OBR)this.getTyped("OBR", OBR.class);
        return retVal;
    }

    public PRT getPRT() {
        PRT retVal = (PRT)this.getTyped("PRT", PRT.class);
        return retVal;
    }

    public PRT getPRT(int rep) {
        PRT retVal = (PRT)this.getTyped("PRT", rep, PRT.class);
        return retVal;
    }

    public int getPRTReps() {
        return this.getReps("PRT");
    }

    public List<PRT> getPRTAll() throws HL7Exception {
        return this.getAllAsList("PRT", PRT.class);
    }

    public void insertPRT(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT", (Structure)structure, rep);
    }

    public PRT insertPRT(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT", rep);
    }

    public PRT removePRT(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT", rep);
    }

    public CSU_C09_TIMING_QTY getTIMING_QTY() {
        CSU_C09_TIMING_QTY retVal = (CSU_C09_TIMING_QTY)this.getTyped("TIMING_QTY", CSU_C09_TIMING_QTY.class);
        return retVal;
    }

    public CSU_C09_TIMING_QTY getTIMING_QTY(int rep) {
        CSU_C09_TIMING_QTY retVal = (CSU_C09_TIMING_QTY)this.getTyped("TIMING_QTY", rep, CSU_C09_TIMING_QTY.class);
        return retVal;
    }

    public int getTIMING_QTYReps() {
        return this.getReps("TIMING_QTY");
    }

    public List<CSU_C09_TIMING_QTY> getTIMING_QTYAll() throws HL7Exception {
        return this.getAllAsList("TIMING_QTY", CSU_C09_TIMING_QTY.class);
    }

    public void insertTIMING_QTY(CSU_C09_TIMING_QTY structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING_QTY", (Structure)structure, rep);
    }

    public CSU_C09_TIMING_QTY insertTIMING_QTY(int rep) throws HL7Exception {
        return (CSU_C09_TIMING_QTY)super.insertRepetition("TIMING_QTY", rep);
    }

    public CSU_C09_TIMING_QTY removeTIMING_QTY(int rep) throws HL7Exception {
        return (CSU_C09_TIMING_QTY)super.removeRepetition("TIMING_QTY", rep);
    }

    public OBX getOBX() {
        OBX retVal = (OBX)this.getTyped("OBX", OBX.class);
        return retVal;
    }

    public PRT getPRT2() {
        PRT retVal = (PRT)this.getTyped("PRT2", PRT.class);
        return retVal;
    }

    public PRT getPRT2(int rep) {
        PRT retVal = (PRT)this.getTyped("PRT2", rep, PRT.class);
        return retVal;
    }

    public int getPRT2Reps() {
        return this.getReps("PRT2");
    }

    public List<PRT> getPRT2All() throws HL7Exception {
        return this.getAllAsList("PRT2", PRT.class);
    }

    public void insertPRT2(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT2", (Structure)structure, rep);
    }

    public PRT insertPRT2(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT2", rep);
    }

    public PRT removePRT2(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT2", rep);
    }
}

