/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v28.group.DFT_P03_COMMON_ORDER;
import ca.uhn.hl7v2.model.v28.group.DFT_P03_FINANCIAL;
import ca.uhn.hl7v2.model.v28.group.DFT_P03_INSURANCE;
import ca.uhn.hl7v2.model.v28.segment.ACC;
import ca.uhn.hl7v2.model.v28.segment.DB1;
import ca.uhn.hl7v2.model.v28.segment.DG1;
import ca.uhn.hl7v2.model.v28.segment.DRG;
import ca.uhn.hl7v2.model.v28.segment.EVN;
import ca.uhn.hl7v2.model.v28.segment.GT1;
import ca.uhn.hl7v2.model.v28.segment.MSH;
import ca.uhn.hl7v2.model.v28.segment.PD1;
import ca.uhn.hl7v2.model.v28.segment.PID;
import ca.uhn.hl7v2.model.v28.segment.PRT;
import ca.uhn.hl7v2.model.v28.segment.PV1;
import ca.uhn.hl7v2.model.v28.segment.PV2;
import ca.uhn.hl7v2.model.v28.segment.ROL;
import ca.uhn.hl7v2.model.v28.segment.SFT;
import ca.uhn.hl7v2.model.v28.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class DFT_P03
extends AbstractMessage {
    public DFT_P03() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public DFT_P03(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(EVN.class, true, false);
            this.add(PID.class, true, false);
            this.add(PD1.class, false, false);
            this.add(PRT.class, false, true);
            this.add(ROL.class, false, true);
            this.add(PV1.class, false, false);
            this.add(PV2.class, false, false);
            this.add(PRT.class, false, true);
            this.add(ROL.class, false, true);
            this.add(DB1.class, false, true);
            this.add(DFT_P03_COMMON_ORDER.class, false, true);
            this.add(DFT_P03_FINANCIAL.class, true, true);
            this.add(DG1.class, false, true);
            this.add(DRG.class, false, false);
            this.add(GT1.class, false, true);
            this.add(DFT_P03_INSURANCE.class, false, true);
            this.add(ACC.class, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating DFT_P03 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return (UAC)this.getTyped("UAC", UAC.class);
    }

    public EVN getEVN() {
        return (EVN)this.getTyped("EVN", EVN.class);
    }

    public PID getPID() {
        return (PID)this.getTyped("PID", PID.class);
    }

    public PD1 getPD1() {
        return (PD1)this.getTyped("PD1", PD1.class);
    }

    public PRT getPRT() {
        return (PRT)this.getTyped("PRT", PRT.class);
    }

    public PRT getPRT(int rep) {
        return (PRT)this.getTyped("PRT", rep, PRT.class);
    }

    public int getPRTReps() {
        return this.getReps("PRT");
    }

    public List<PRT> getPRTAll() throws HL7Exception {
        return this.getAllAsList("PRT", PRT.class);
    }

    public void insertPRT(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT", (Structure)structure, rep);
    }

    public PRT insertPRT(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT", rep);
    }

    public PRT removePRT(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT", rep);
    }

    public ROL getROL() {
        return (ROL)this.getTyped("ROL", ROL.class);
    }

    public ROL getROL(int rep) {
        return (ROL)this.getTyped("ROL", rep, ROL.class);
    }

    public int getROLReps() {
        return this.getReps("ROL");
    }

    public List<ROL> getROLAll() throws HL7Exception {
        return this.getAllAsList("ROL", ROL.class);
    }

    public void insertROL(ROL structure, int rep) throws HL7Exception {
        super.insertRepetition("ROL", (Structure)structure, rep);
    }

    public ROL insertROL(int rep) throws HL7Exception {
        return (ROL)super.insertRepetition("ROL", rep);
    }

    public ROL removeROL(int rep) throws HL7Exception {
        return (ROL)super.removeRepetition("ROL", rep);
    }

    public PV1 getPV1() {
        return (PV1)this.getTyped("PV1", PV1.class);
    }

    public PV2 getPV2() {
        return (PV2)this.getTyped("PV2", PV2.class);
    }

    public PRT getPRT2() {
        return (PRT)this.getTyped("PRT2", PRT.class);
    }

    public PRT getPRT2(int rep) {
        return (PRT)this.getTyped("PRT2", rep, PRT.class);
    }

    public int getPRT2Reps() {
        return this.getReps("PRT2");
    }

    public List<PRT> getPRT2All() throws HL7Exception {
        return this.getAllAsList("PRT2", PRT.class);
    }

    public void insertPRT2(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT2", (Structure)structure, rep);
    }

    public PRT insertPRT2(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT2", rep);
    }

    public PRT removePRT2(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT2", rep);
    }

    public ROL getROL2() {
        return (ROL)this.getTyped("ROL2", ROL.class);
    }

    public ROL getROL2(int rep) {
        return (ROL)this.getTyped("ROL2", rep, ROL.class);
    }

    public int getROL2Reps() {
        return this.getReps("ROL2");
    }

    public List<ROL> getROL2All() throws HL7Exception {
        return this.getAllAsList("ROL2", ROL.class);
    }

    public void insertROL2(ROL structure, int rep) throws HL7Exception {
        super.insertRepetition("ROL2", (Structure)structure, rep);
    }

    public ROL insertROL2(int rep) throws HL7Exception {
        return (ROL)super.insertRepetition("ROL2", rep);
    }

    public ROL removeROL2(int rep) throws HL7Exception {
        return (ROL)super.removeRepetition("ROL2", rep);
    }

    public DB1 getDB1() {
        return (DB1)this.getTyped("DB1", DB1.class);
    }

    public DB1 getDB1(int rep) {
        return (DB1)this.getTyped("DB1", rep, DB1.class);
    }

    public int getDB1Reps() {
        return this.getReps("DB1");
    }

    public List<DB1> getDB1All() throws HL7Exception {
        return this.getAllAsList("DB1", DB1.class);
    }

    public void insertDB1(DB1 structure, int rep) throws HL7Exception {
        super.insertRepetition("DB1", (Structure)structure, rep);
    }

    public DB1 insertDB1(int rep) throws HL7Exception {
        return (DB1)super.insertRepetition("DB1", rep);
    }

    public DB1 removeDB1(int rep) throws HL7Exception {
        return (DB1)super.removeRepetition("DB1", rep);
    }

    public DFT_P03_COMMON_ORDER getCOMMON_ORDER() {
        return (DFT_P03_COMMON_ORDER)this.getTyped("COMMON_ORDER", DFT_P03_COMMON_ORDER.class);
    }

    public DFT_P03_COMMON_ORDER getCOMMON_ORDER(int rep) {
        return (DFT_P03_COMMON_ORDER)this.getTyped("COMMON_ORDER", rep, DFT_P03_COMMON_ORDER.class);
    }

    public int getCOMMON_ORDERReps() {
        return this.getReps("COMMON_ORDER");
    }

    public List<DFT_P03_COMMON_ORDER> getCOMMON_ORDERAll() throws HL7Exception {
        return this.getAllAsList("COMMON_ORDER", DFT_P03_COMMON_ORDER.class);
    }

    public void insertCOMMON_ORDER(DFT_P03_COMMON_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("COMMON_ORDER", (Structure)structure, rep);
    }

    public DFT_P03_COMMON_ORDER insertCOMMON_ORDER(int rep) throws HL7Exception {
        return (DFT_P03_COMMON_ORDER)super.insertRepetition("COMMON_ORDER", rep);
    }

    public DFT_P03_COMMON_ORDER removeCOMMON_ORDER(int rep) throws HL7Exception {
        return (DFT_P03_COMMON_ORDER)super.removeRepetition("COMMON_ORDER", rep);
    }

    public DFT_P03_FINANCIAL getFINANCIAL() {
        return (DFT_P03_FINANCIAL)this.getTyped("FINANCIAL", DFT_P03_FINANCIAL.class);
    }

    public DFT_P03_FINANCIAL getFINANCIAL(int rep) {
        return (DFT_P03_FINANCIAL)this.getTyped("FINANCIAL", rep, DFT_P03_FINANCIAL.class);
    }

    public int getFINANCIALReps() {
        return this.getReps("FINANCIAL");
    }

    public List<DFT_P03_FINANCIAL> getFINANCIALAll() throws HL7Exception {
        return this.getAllAsList("FINANCIAL", DFT_P03_FINANCIAL.class);
    }

    public void insertFINANCIAL(DFT_P03_FINANCIAL structure, int rep) throws HL7Exception {
        super.insertRepetition("FINANCIAL", (Structure)structure, rep);
    }

    public DFT_P03_FINANCIAL insertFINANCIAL(int rep) throws HL7Exception {
        return (DFT_P03_FINANCIAL)super.insertRepetition("FINANCIAL", rep);
    }

    public DFT_P03_FINANCIAL removeFINANCIAL(int rep) throws HL7Exception {
        return (DFT_P03_FINANCIAL)super.removeRepetition("FINANCIAL", rep);
    }

    public DG1 getDG1() {
        return (DG1)this.getTyped("DG1", DG1.class);
    }

    public DG1 getDG1(int rep) {
        return (DG1)this.getTyped("DG1", rep, DG1.class);
    }

    public int getDG1Reps() {
        return this.getReps("DG1");
    }

    public List<DG1> getDG1All() throws HL7Exception {
        return this.getAllAsList("DG1", DG1.class);
    }

    public void insertDG1(DG1 structure, int rep) throws HL7Exception {
        super.insertRepetition("DG1", (Structure)structure, rep);
    }

    public DG1 insertDG1(int rep) throws HL7Exception {
        return (DG1)super.insertRepetition("DG1", rep);
    }

    public DG1 removeDG1(int rep) throws HL7Exception {
        return (DG1)super.removeRepetition("DG1", rep);
    }

    public DRG getDRG() {
        return (DRG)this.getTyped("DRG", DRG.class);
    }

    public GT1 getGT1() {
        return (GT1)this.getTyped("GT1", GT1.class);
    }

    public GT1 getGT1(int rep) {
        return (GT1)this.getTyped("GT1", rep, GT1.class);
    }

    public int getGT1Reps() {
        return this.getReps("GT1");
    }

    public List<GT1> getGT1All() throws HL7Exception {
        return this.getAllAsList("GT1", GT1.class);
    }

    public void insertGT1(GT1 structure, int rep) throws HL7Exception {
        super.insertRepetition("GT1", (Structure)structure, rep);
    }

    public GT1 insertGT1(int rep) throws HL7Exception {
        return (GT1)super.insertRepetition("GT1", rep);
    }

    public GT1 removeGT1(int rep) throws HL7Exception {
        return (GT1)super.removeRepetition("GT1", rep);
    }

    public DFT_P03_INSURANCE getINSURANCE() {
        return (DFT_P03_INSURANCE)this.getTyped("INSURANCE", DFT_P03_INSURANCE.class);
    }

    public DFT_P03_INSURANCE getINSURANCE(int rep) {
        return (DFT_P03_INSURANCE)this.getTyped("INSURANCE", rep, DFT_P03_INSURANCE.class);
    }

    public int getINSURANCEReps() {
        return this.getReps("INSURANCE");
    }

    public List<DFT_P03_INSURANCE> getINSURANCEAll() throws HL7Exception {
        return this.getAllAsList("INSURANCE", DFT_P03_INSURANCE.class);
    }

    public void insertINSURANCE(DFT_P03_INSURANCE structure, int rep) throws HL7Exception {
        super.insertRepetition("INSURANCE", (Structure)structure, rep);
    }

    public DFT_P03_INSURANCE insertINSURANCE(int rep) throws HL7Exception {
        return (DFT_P03_INSURANCE)super.insertRepetition("INSURANCE", rep);
    }

    public DFT_P03_INSURANCE removeINSURANCE(int rep) throws HL7Exception {
        return (DFT_P03_INSURANCE)super.removeRepetition("INSURANCE", rep);
    }

    public ACC getACC() {
        return (ACC)this.getTyped("ACC", ACC.class);
    }
}

