/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v28.segment.MSH;
import ca.uhn.hl7v2.model.v28.segment.SCP;
import ca.uhn.hl7v2.model.v28.segment.SFT;
import ca.uhn.hl7v2.model.v28.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class STC_S33
extends AbstractMessage {
    public STC_S33() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public STC_S33(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(SCP.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating STC_S33 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return (UAC)this.getTyped("UAC", UAC.class);
    }

    public SCP getSCP() {
        return (SCP)this.getTyped("SCP", SCP.class);
    }

    public SCP getSCP(int rep) {
        return (SCP)this.getTyped("SCP", rep, SCP.class);
    }

    public int getSCPReps() {
        return this.getReps("SCP");
    }

    public List<SCP> getSCPAll() throws HL7Exception {
        return this.getAllAsList("SCP", SCP.class);
    }

    public void insertSCP(SCP structure, int rep) throws HL7Exception {
        super.insertRepetition("SCP", (Structure)structure, rep);
    }

    public SCP insertSCP(int rep) throws HL7Exception {
        return (SCP)super.insertRepetition("SCP", rep);
    }

    public SCP removeSCP(int rep) throws HL7Exception {
        return (SCP)super.removeRepetition("SCP", rep);
    }
}

