/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v28.datatype.CNE;
import ca.uhn.hl7v2.model.v28.datatype.CWE;
import ca.uhn.hl7v2.model.v28.datatype.DTM;
import ca.uhn.hl7v2.model.v28.datatype.ID;
import ca.uhn.hl7v2.model.v28.datatype.NM;
import ca.uhn.hl7v2.model.v28.datatype.SI;
import ca.uhn.hl7v2.model.v28.datatype.XCN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class AIP
extends AbstractSegment {
    public AIP(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage()}, "Set ID - AIP");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(206)}, "Segment Action Code");
            this.add(XCN.class, false, 0, 0, new Object[]{this.getMessage()}, "Personnel Resource ID");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Resource Type");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Resource Group");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Start Date/Time");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Start Date/Time Offset");
            this.add(CNE.class, false, 1, 0, new Object[]{this.getMessage()}, "Start Date/Time Offset Units");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Duration");
            this.add(CNE.class, false, 1, 0, new Object[]{this.getMessage()}, "Duration Units");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Allow Substitution Code");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Filler Status Code");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating AIP - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDAIP() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getAip1_SetIDAIP() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getSegmentActionCode() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getAip2_SegmentActionCode() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public XCN[] getPersonnelResourceID() {
        XCN[] retVal = (XCN[])this.getTypedField(3, (Type[])new XCN[0]);
        return retVal;
    }

    public XCN[] getAip3_PersonnelResourceID() {
        XCN[] retVal = (XCN[])this.getTypedField(3, (Type[])new XCN[0]);
        return retVal;
    }

    public int getPersonnelResourceIDReps() {
        return this.getReps(3);
    }

    public XCN getPersonnelResourceID(int rep) {
        XCN retVal = (XCN)this.getTypedField(3, rep);
        return retVal;
    }

    public XCN getAip3_PersonnelResourceID(int rep) {
        XCN retVal = (XCN)this.getTypedField(3, rep);
        return retVal;
    }

    public int getAip3_PersonnelResourceIDReps() {
        return this.getReps(3);
    }

    public XCN insertPersonnelResourceID(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(3, rep);
    }

    public XCN insertAip3_PersonnelResourceID(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(3, rep);
    }

    public XCN removePersonnelResourceID(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(3, rep);
    }

    public XCN removeAip3_PersonnelResourceID(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(3, rep);
    }

    public CWE getResourceType() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getAip4_ResourceType() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getResourceGroup() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getAip5_ResourceGroup() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public DTM getStartDateTime() {
        DTM retVal = (DTM)this.getTypedField(6, 0);
        return retVal;
    }

    public DTM getAip6_StartDateTime() {
        DTM retVal = (DTM)this.getTypedField(6, 0);
        return retVal;
    }

    public NM getStartDateTimeOffset() {
        NM retVal = (NM)this.getTypedField(7, 0);
        return retVal;
    }

    public NM getAip7_StartDateTimeOffset() {
        NM retVal = (NM)this.getTypedField(7, 0);
        return retVal;
    }

    public CNE getStartDateTimeOffsetUnits() {
        CNE retVal = (CNE)this.getTypedField(8, 0);
        return retVal;
    }

    public CNE getAip8_StartDateTimeOffsetUnits() {
        CNE retVal = (CNE)this.getTypedField(8, 0);
        return retVal;
    }

    public NM getDuration() {
        NM retVal = (NM)this.getTypedField(9, 0);
        return retVal;
    }

    public NM getAip9_Duration() {
        NM retVal = (NM)this.getTypedField(9, 0);
        return retVal;
    }

    public CNE getDurationUnits() {
        CNE retVal = (CNE)this.getTypedField(10, 0);
        return retVal;
    }

    public CNE getAip10_DurationUnits() {
        CNE retVal = (CNE)this.getTypedField(10, 0);
        return retVal;
    }

    public CWE getAllowSubstitutionCode() {
        CWE retVal = (CWE)this.getTypedField(11, 0);
        return retVal;
    }

    public CWE getAip11_AllowSubstitutionCode() {
        CWE retVal = (CWE)this.getTypedField(11, 0);
        return retVal;
    }

    public CWE getFillerStatusCode() {
        CWE retVal = (CWE)this.getTypedField(12, 0);
        return retVal;
    }

    public CWE getAip12_FillerStatusCode() {
        CWE retVal = (CWE)this.getTypedField(12, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(206));
            }
            case 2: {
                return new XCN(this.getMessage());
            }
            case 3: {
                return new CWE(this.getMessage());
            }
            case 4: {
                return new CWE(this.getMessage());
            }
            case 5: {
                return new DTM(this.getMessage());
            }
            case 6: {
                return new NM(this.getMessage());
            }
            case 7: {
                return new CNE(this.getMessage());
            }
            case 8: {
                return new NM(this.getMessage());
            }
            case 9: {
                return new CNE(this.getMessage());
            }
            case 10: {
                return new CWE(this.getMessage());
            }
            case 11: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

