/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v28.datatype.CWE;
import ca.uhn.hl7v2.model.v28.datatype.CX;
import ca.uhn.hl7v2.model.v28.datatype.DLD;
import ca.uhn.hl7v2.model.v28.datatype.DT;
import ca.uhn.hl7v2.model.v28.datatype.DTM;
import ca.uhn.hl7v2.model.v28.datatype.FC;
import ca.uhn.hl7v2.model.v28.datatype.NM;
import ca.uhn.hl7v2.model.v28.datatype.NULLDT;
import ca.uhn.hl7v2.model.v28.datatype.PL;
import ca.uhn.hl7v2.model.v28.datatype.SI;
import ca.uhn.hl7v2.model.v28.datatype.ST;
import ca.uhn.hl7v2.model.v28.datatype.XCN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PV1
extends AbstractSegment {
    public PV1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage()}, "Set ID - PV1");
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "Patient Class");
            this.add(PL.class, false, 1, 0, new Object[]{this.getMessage()}, "Assigned Patient Location");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Admission Type");
            this.add(CX.class, false, 1, 0, new Object[]{this.getMessage()}, "Preadmit Number");
            this.add(PL.class, false, 1, 0, new Object[]{this.getMessage()}, "Prior Patient Location");
            this.add(XCN.class, false, 0, 0, new Object[]{this.getMessage()}, "Attending Doctor");
            this.add(XCN.class, false, 0, 0, new Object[]{this.getMessage()}, "Referring Doctor");
            this.add(XCN.class, false, 0, 0, new Object[]{this.getMessage()}, "Consulting Doctor");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Hospital Service");
            this.add(PL.class, false, 1, 0, new Object[]{this.getMessage()}, "Temporary Location");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Preadmit Test Indicator");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Re-admission Indicator");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Admit Source");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Ambulatory Status");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "VIP Indicator");
            this.add(XCN.class, false, 0, 0, new Object[]{this.getMessage()}, "Admitting Doctor");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Patient Type");
            this.add(CX.class, false, 1, 0, new Object[]{this.getMessage()}, "Visit Number");
            this.add(FC.class, false, 0, 0, new Object[]{this.getMessage()}, "Financial Class");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Charge Price Indicator");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Courtesy Code");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Credit Rating");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Contract Code");
            this.add(DT.class, false, 0, 0, new Object[]{this.getMessage()}, "Contract Effective Date");
            this.add(NM.class, false, 0, 0, new Object[]{this.getMessage()}, "Contract Amount");
            this.add(NM.class, false, 0, 0, new Object[]{this.getMessage()}, "Contract Period");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Interest Code");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Transfer to Bad Debt Code");
            this.add(DT.class, false, 1, 0, new Object[]{this.getMessage()}, "Transfer to Bad Debt Date");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Bad Debt Agency Code");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Bad Debt Transfer Amount");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Bad Debt Recovery Amount");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Delete Account Indicator");
            this.add(DT.class, false, 1, 0, new Object[]{this.getMessage()}, "Delete Account Date");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Discharge Disposition");
            this.add(DLD.class, false, 1, 0, new Object[]{this.getMessage()}, "Discharged to Location");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Diet Type");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Servicing Facility");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Bed Status");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Account Status");
            this.add(PL.class, false, 1, 0, new Object[]{this.getMessage()}, "Pending Location");
            this.add(PL.class, false, 1, 0, new Object[]{this.getMessage()}, "Prior Temporary Location");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Admit Date/Time");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Discharge Date/Time");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Current Patient Balance");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Total Charges");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Total Adjustments");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Total Payments");
            this.add(CX.class, false, 0, 0, new Object[]{this.getMessage()}, "Alternate Visit ID");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Visit Indicator");
            this.add(NULLDT.class, false, 1, 0, new Object[]{this.getMessage()}, "Other Healthcare Provider");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Service Episode Description");
            this.add(CX.class, false, 1, 0, new Object[]{this.getMessage()}, "Service Episode Identifier");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PV1 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDPV1() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getPv11_SetIDPV1() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getPatientClass() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getPv12_PatientClass() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public PL getAssignedPatientLocation() {
        PL retVal = (PL)this.getTypedField(3, 0);
        return retVal;
    }

    public PL getPv13_AssignedPatientLocation() {
        PL retVal = (PL)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getAdmissionType() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getPv14_AdmissionType() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CX getPreadmitNumber() {
        CX retVal = (CX)this.getTypedField(5, 0);
        return retVal;
    }

    public CX getPv15_PreadmitNumber() {
        CX retVal = (CX)this.getTypedField(5, 0);
        return retVal;
    }

    public PL getPriorPatientLocation() {
        PL retVal = (PL)this.getTypedField(6, 0);
        return retVal;
    }

    public PL getPv16_PriorPatientLocation() {
        PL retVal = (PL)this.getTypedField(6, 0);
        return retVal;
    }

    public XCN[] getAttendingDoctor() {
        XCN[] retVal = (XCN[])this.getTypedField(7, (Type[])new XCN[0]);
        return retVal;
    }

    public XCN[] getPv17_AttendingDoctor() {
        XCN[] retVal = (XCN[])this.getTypedField(7, (Type[])new XCN[0]);
        return retVal;
    }

    public int getAttendingDoctorReps() {
        return this.getReps(7);
    }

    public XCN getAttendingDoctor(int rep) {
        XCN retVal = (XCN)this.getTypedField(7, rep);
        return retVal;
    }

    public XCN getPv17_AttendingDoctor(int rep) {
        XCN retVal = (XCN)this.getTypedField(7, rep);
        return retVal;
    }

    public int getPv17_AttendingDoctorReps() {
        return this.getReps(7);
    }

    public XCN insertAttendingDoctor(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(7, rep);
    }

    public XCN insertPv17_AttendingDoctor(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(7, rep);
    }

    public XCN removeAttendingDoctor(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(7, rep);
    }

    public XCN removePv17_AttendingDoctor(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(7, rep);
    }

    public XCN[] getReferringDoctor() {
        XCN[] retVal = (XCN[])this.getTypedField(8, (Type[])new XCN[0]);
        return retVal;
    }

    public XCN[] getPv18_ReferringDoctor() {
        XCN[] retVal = (XCN[])this.getTypedField(8, (Type[])new XCN[0]);
        return retVal;
    }

    public int getReferringDoctorReps() {
        return this.getReps(8);
    }

    public XCN getReferringDoctor(int rep) {
        XCN retVal = (XCN)this.getTypedField(8, rep);
        return retVal;
    }

    public XCN getPv18_ReferringDoctor(int rep) {
        XCN retVal = (XCN)this.getTypedField(8, rep);
        return retVal;
    }

    public int getPv18_ReferringDoctorReps() {
        return this.getReps(8);
    }

    public XCN insertReferringDoctor(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(8, rep);
    }

    public XCN insertPv18_ReferringDoctor(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(8, rep);
    }

    public XCN removeReferringDoctor(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(8, rep);
    }

    public XCN removePv18_ReferringDoctor(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(8, rep);
    }

    public XCN[] getConsultingDoctor() {
        XCN[] retVal = (XCN[])this.getTypedField(9, (Type[])new XCN[0]);
        return retVal;
    }

    public XCN[] getPv19_ConsultingDoctor() {
        XCN[] retVal = (XCN[])this.getTypedField(9, (Type[])new XCN[0]);
        return retVal;
    }

    public int getConsultingDoctorReps() {
        return this.getReps(9);
    }

    public XCN getConsultingDoctor(int rep) {
        XCN retVal = (XCN)this.getTypedField(9, rep);
        return retVal;
    }

    public XCN getPv19_ConsultingDoctor(int rep) {
        XCN retVal = (XCN)this.getTypedField(9, rep);
        return retVal;
    }

    public int getPv19_ConsultingDoctorReps() {
        return this.getReps(9);
    }

    public XCN insertConsultingDoctor(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(9, rep);
    }

    public XCN insertPv19_ConsultingDoctor(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(9, rep);
    }

    public XCN removeConsultingDoctor(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(9, rep);
    }

    public XCN removePv19_ConsultingDoctor(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(9, rep);
    }

    public CWE getHospitalService() {
        CWE retVal = (CWE)this.getTypedField(10, 0);
        return retVal;
    }

    public CWE getPv110_HospitalService() {
        CWE retVal = (CWE)this.getTypedField(10, 0);
        return retVal;
    }

    public PL getTemporaryLocation() {
        PL retVal = (PL)this.getTypedField(11, 0);
        return retVal;
    }

    public PL getPv111_TemporaryLocation() {
        PL retVal = (PL)this.getTypedField(11, 0);
        return retVal;
    }

    public CWE getPreadmitTestIndicator() {
        CWE retVal = (CWE)this.getTypedField(12, 0);
        return retVal;
    }

    public CWE getPv112_PreadmitTestIndicator() {
        CWE retVal = (CWE)this.getTypedField(12, 0);
        return retVal;
    }

    public CWE getReAdmissionIndicator() {
        CWE retVal = (CWE)this.getTypedField(13, 0);
        return retVal;
    }

    public CWE getPv113_ReAdmissionIndicator() {
        CWE retVal = (CWE)this.getTypedField(13, 0);
        return retVal;
    }

    public CWE getAdmitSource() {
        CWE retVal = (CWE)this.getTypedField(14, 0);
        return retVal;
    }

    public CWE getPv114_AdmitSource() {
        CWE retVal = (CWE)this.getTypedField(14, 0);
        return retVal;
    }

    public CWE[] getAmbulatoryStatus() {
        CWE[] retVal = (CWE[])this.getTypedField(15, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getPv115_AmbulatoryStatus() {
        CWE[] retVal = (CWE[])this.getTypedField(15, (Type[])new CWE[0]);
        return retVal;
    }

    public int getAmbulatoryStatusReps() {
        return this.getReps(15);
    }

    public CWE getAmbulatoryStatus(int rep) {
        CWE retVal = (CWE)this.getTypedField(15, rep);
        return retVal;
    }

    public CWE getPv115_AmbulatoryStatus(int rep) {
        CWE retVal = (CWE)this.getTypedField(15, rep);
        return retVal;
    }

    public int getPv115_AmbulatoryStatusReps() {
        return this.getReps(15);
    }

    public CWE insertAmbulatoryStatus(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(15, rep);
    }

    public CWE insertPv115_AmbulatoryStatus(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(15, rep);
    }

    public CWE removeAmbulatoryStatus(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(15, rep);
    }

    public CWE removePv115_AmbulatoryStatus(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(15, rep);
    }

    public CWE getVIPIndicator() {
        CWE retVal = (CWE)this.getTypedField(16, 0);
        return retVal;
    }

    public CWE getPv116_VIPIndicator() {
        CWE retVal = (CWE)this.getTypedField(16, 0);
        return retVal;
    }

    public XCN[] getAdmittingDoctor() {
        XCN[] retVal = (XCN[])this.getTypedField(17, (Type[])new XCN[0]);
        return retVal;
    }

    public XCN[] getPv117_AdmittingDoctor() {
        XCN[] retVal = (XCN[])this.getTypedField(17, (Type[])new XCN[0]);
        return retVal;
    }

    public int getAdmittingDoctorReps() {
        return this.getReps(17);
    }

    public XCN getAdmittingDoctor(int rep) {
        XCN retVal = (XCN)this.getTypedField(17, rep);
        return retVal;
    }

    public XCN getPv117_AdmittingDoctor(int rep) {
        XCN retVal = (XCN)this.getTypedField(17, rep);
        return retVal;
    }

    public int getPv117_AdmittingDoctorReps() {
        return this.getReps(17);
    }

    public XCN insertAdmittingDoctor(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(17, rep);
    }

    public XCN insertPv117_AdmittingDoctor(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(17, rep);
    }

    public XCN removeAdmittingDoctor(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(17, rep);
    }

    public XCN removePv117_AdmittingDoctor(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(17, rep);
    }

    public CWE getPatientType() {
        CWE retVal = (CWE)this.getTypedField(18, 0);
        return retVal;
    }

    public CWE getPv118_PatientType() {
        CWE retVal = (CWE)this.getTypedField(18, 0);
        return retVal;
    }

    public CX getVisitNumber() {
        CX retVal = (CX)this.getTypedField(19, 0);
        return retVal;
    }

    public CX getPv119_VisitNumber() {
        CX retVal = (CX)this.getTypedField(19, 0);
        return retVal;
    }

    public FC[] getFinancialClass() {
        FC[] retVal = (FC[])this.getTypedField(20, (Type[])new FC[0]);
        return retVal;
    }

    public FC[] getPv120_FinancialClass() {
        FC[] retVal = (FC[])this.getTypedField(20, (Type[])new FC[0]);
        return retVal;
    }

    public int getFinancialClassReps() {
        return this.getReps(20);
    }

    public FC getFinancialClass(int rep) {
        FC retVal = (FC)this.getTypedField(20, rep);
        return retVal;
    }

    public FC getPv120_FinancialClass(int rep) {
        FC retVal = (FC)this.getTypedField(20, rep);
        return retVal;
    }

    public int getPv120_FinancialClassReps() {
        return this.getReps(20);
    }

    public FC insertFinancialClass(int rep) throws HL7Exception {
        return (FC)super.insertRepetition(20, rep);
    }

    public FC insertPv120_FinancialClass(int rep) throws HL7Exception {
        return (FC)super.insertRepetition(20, rep);
    }

    public FC removeFinancialClass(int rep) throws HL7Exception {
        return (FC)super.removeRepetition(20, rep);
    }

    public FC removePv120_FinancialClass(int rep) throws HL7Exception {
        return (FC)super.removeRepetition(20, rep);
    }

    public CWE getChargePriceIndicator() {
        CWE retVal = (CWE)this.getTypedField(21, 0);
        return retVal;
    }

    public CWE getPv121_ChargePriceIndicator() {
        CWE retVal = (CWE)this.getTypedField(21, 0);
        return retVal;
    }

    public CWE getCourtesyCode() {
        CWE retVal = (CWE)this.getTypedField(22, 0);
        return retVal;
    }

    public CWE getPv122_CourtesyCode() {
        CWE retVal = (CWE)this.getTypedField(22, 0);
        return retVal;
    }

    public CWE getCreditRating() {
        CWE retVal = (CWE)this.getTypedField(23, 0);
        return retVal;
    }

    public CWE getPv123_CreditRating() {
        CWE retVal = (CWE)this.getTypedField(23, 0);
        return retVal;
    }

    public CWE[] getContractCode() {
        CWE[] retVal = (CWE[])this.getTypedField(24, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getPv124_ContractCode() {
        CWE[] retVal = (CWE[])this.getTypedField(24, (Type[])new CWE[0]);
        return retVal;
    }

    public int getContractCodeReps() {
        return this.getReps(24);
    }

    public CWE getContractCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(24, rep);
        return retVal;
    }

    public CWE getPv124_ContractCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(24, rep);
        return retVal;
    }

    public int getPv124_ContractCodeReps() {
        return this.getReps(24);
    }

    public CWE insertContractCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(24, rep);
    }

    public CWE insertPv124_ContractCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(24, rep);
    }

    public CWE removeContractCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(24, rep);
    }

    public CWE removePv124_ContractCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(24, rep);
    }

    public DT[] getContractEffectiveDate() {
        DT[] retVal = (DT[])this.getTypedField(25, (Type[])new DT[0]);
        return retVal;
    }

    public DT[] getPv125_ContractEffectiveDate() {
        DT[] retVal = (DT[])this.getTypedField(25, (Type[])new DT[0]);
        return retVal;
    }

    public int getContractEffectiveDateReps() {
        return this.getReps(25);
    }

    public DT getContractEffectiveDate(int rep) {
        DT retVal = (DT)this.getTypedField(25, rep);
        return retVal;
    }

    public DT getPv125_ContractEffectiveDate(int rep) {
        DT retVal = (DT)this.getTypedField(25, rep);
        return retVal;
    }

    public int getPv125_ContractEffectiveDateReps() {
        return this.getReps(25);
    }

    public DT insertContractEffectiveDate(int rep) throws HL7Exception {
        return (DT)super.insertRepetition(25, rep);
    }

    public DT insertPv125_ContractEffectiveDate(int rep) throws HL7Exception {
        return (DT)super.insertRepetition(25, rep);
    }

    public DT removeContractEffectiveDate(int rep) throws HL7Exception {
        return (DT)super.removeRepetition(25, rep);
    }

    public DT removePv125_ContractEffectiveDate(int rep) throws HL7Exception {
        return (DT)super.removeRepetition(25, rep);
    }

    public NM[] getContractAmount() {
        NM[] retVal = (NM[])this.getTypedField(26, (Type[])new NM[0]);
        return retVal;
    }

    public NM[] getPv126_ContractAmount() {
        NM[] retVal = (NM[])this.getTypedField(26, (Type[])new NM[0]);
        return retVal;
    }

    public int getContractAmountReps() {
        return this.getReps(26);
    }

    public NM getContractAmount(int rep) {
        NM retVal = (NM)this.getTypedField(26, rep);
        return retVal;
    }

    public NM getPv126_ContractAmount(int rep) {
        NM retVal = (NM)this.getTypedField(26, rep);
        return retVal;
    }

    public int getPv126_ContractAmountReps() {
        return this.getReps(26);
    }

    public NM insertContractAmount(int rep) throws HL7Exception {
        return (NM)super.insertRepetition(26, rep);
    }

    public NM insertPv126_ContractAmount(int rep) throws HL7Exception {
        return (NM)super.insertRepetition(26, rep);
    }

    public NM removeContractAmount(int rep) throws HL7Exception {
        return (NM)super.removeRepetition(26, rep);
    }

    public NM removePv126_ContractAmount(int rep) throws HL7Exception {
        return (NM)super.removeRepetition(26, rep);
    }

    public NM[] getContractPeriod() {
        NM[] retVal = (NM[])this.getTypedField(27, (Type[])new NM[0]);
        return retVal;
    }

    public NM[] getPv127_ContractPeriod() {
        NM[] retVal = (NM[])this.getTypedField(27, (Type[])new NM[0]);
        return retVal;
    }

    public int getContractPeriodReps() {
        return this.getReps(27);
    }

    public NM getContractPeriod(int rep) {
        NM retVal = (NM)this.getTypedField(27, rep);
        return retVal;
    }

    public NM getPv127_ContractPeriod(int rep) {
        NM retVal = (NM)this.getTypedField(27, rep);
        return retVal;
    }

    public int getPv127_ContractPeriodReps() {
        return this.getReps(27);
    }

    public NM insertContractPeriod(int rep) throws HL7Exception {
        return (NM)super.insertRepetition(27, rep);
    }

    public NM insertPv127_ContractPeriod(int rep) throws HL7Exception {
        return (NM)super.insertRepetition(27, rep);
    }

    public NM removeContractPeriod(int rep) throws HL7Exception {
        return (NM)super.removeRepetition(27, rep);
    }

    public NM removePv127_ContractPeriod(int rep) throws HL7Exception {
        return (NM)super.removeRepetition(27, rep);
    }

    public CWE getInterestCode() {
        CWE retVal = (CWE)this.getTypedField(28, 0);
        return retVal;
    }

    public CWE getPv128_InterestCode() {
        CWE retVal = (CWE)this.getTypedField(28, 0);
        return retVal;
    }

    public CWE getTransferToBadDebtCode() {
        CWE retVal = (CWE)this.getTypedField(29, 0);
        return retVal;
    }

    public CWE getPv129_TransferToBadDebtCode() {
        CWE retVal = (CWE)this.getTypedField(29, 0);
        return retVal;
    }

    public DT getTransferToBadDebtDate() {
        DT retVal = (DT)this.getTypedField(30, 0);
        return retVal;
    }

    public DT getPv130_TransferToBadDebtDate() {
        DT retVal = (DT)this.getTypedField(30, 0);
        return retVal;
    }

    public CWE getBadDebtAgencyCode() {
        CWE retVal = (CWE)this.getTypedField(31, 0);
        return retVal;
    }

    public CWE getPv131_BadDebtAgencyCode() {
        CWE retVal = (CWE)this.getTypedField(31, 0);
        return retVal;
    }

    public NM getBadDebtTransferAmount() {
        NM retVal = (NM)this.getTypedField(32, 0);
        return retVal;
    }

    public NM getPv132_BadDebtTransferAmount() {
        NM retVal = (NM)this.getTypedField(32, 0);
        return retVal;
    }

    public NM getBadDebtRecoveryAmount() {
        NM retVal = (NM)this.getTypedField(33, 0);
        return retVal;
    }

    public NM getPv133_BadDebtRecoveryAmount() {
        NM retVal = (NM)this.getTypedField(33, 0);
        return retVal;
    }

    public CWE getDeleteAccountIndicator() {
        CWE retVal = (CWE)this.getTypedField(34, 0);
        return retVal;
    }

    public CWE getPv134_DeleteAccountIndicator() {
        CWE retVal = (CWE)this.getTypedField(34, 0);
        return retVal;
    }

    public DT getDeleteAccountDate() {
        DT retVal = (DT)this.getTypedField(35, 0);
        return retVal;
    }

    public DT getPv135_DeleteAccountDate() {
        DT retVal = (DT)this.getTypedField(35, 0);
        return retVal;
    }

    public CWE getDischargeDisposition() {
        CWE retVal = (CWE)this.getTypedField(36, 0);
        return retVal;
    }

    public CWE getPv136_DischargeDisposition() {
        CWE retVal = (CWE)this.getTypedField(36, 0);
        return retVal;
    }

    public DLD getDischargedToLocation() {
        DLD retVal = (DLD)this.getTypedField(37, 0);
        return retVal;
    }

    public DLD getPv137_DischargedToLocation() {
        DLD retVal = (DLD)this.getTypedField(37, 0);
        return retVal;
    }

    public CWE getDietType() {
        CWE retVal = (CWE)this.getTypedField(38, 0);
        return retVal;
    }

    public CWE getPv138_DietType() {
        CWE retVal = (CWE)this.getTypedField(38, 0);
        return retVal;
    }

    public CWE getServicingFacility() {
        CWE retVal = (CWE)this.getTypedField(39, 0);
        return retVal;
    }

    public CWE getPv139_ServicingFacility() {
        CWE retVal = (CWE)this.getTypedField(39, 0);
        return retVal;
    }

    public CWE getBedStatus() {
        CWE retVal = (CWE)this.getTypedField(40, 0);
        return retVal;
    }

    public CWE getPv140_BedStatus() {
        CWE retVal = (CWE)this.getTypedField(40, 0);
        return retVal;
    }

    public CWE getAccountStatus() {
        CWE retVal = (CWE)this.getTypedField(41, 0);
        return retVal;
    }

    public CWE getPv141_AccountStatus() {
        CWE retVal = (CWE)this.getTypedField(41, 0);
        return retVal;
    }

    public PL getPendingLocation() {
        PL retVal = (PL)this.getTypedField(42, 0);
        return retVal;
    }

    public PL getPv142_PendingLocation() {
        PL retVal = (PL)this.getTypedField(42, 0);
        return retVal;
    }

    public PL getPriorTemporaryLocation() {
        PL retVal = (PL)this.getTypedField(43, 0);
        return retVal;
    }

    public PL getPv143_PriorTemporaryLocation() {
        PL retVal = (PL)this.getTypedField(43, 0);
        return retVal;
    }

    public DTM getAdmitDateTime() {
        DTM retVal = (DTM)this.getTypedField(44, 0);
        return retVal;
    }

    public DTM getPv144_AdmitDateTime() {
        DTM retVal = (DTM)this.getTypedField(44, 0);
        return retVal;
    }

    public DTM getDischargeDateTime() {
        DTM retVal = (DTM)this.getTypedField(45, 0);
        return retVal;
    }

    public DTM getPv145_DischargeDateTime() {
        DTM retVal = (DTM)this.getTypedField(45, 0);
        return retVal;
    }

    public NM getCurrentPatientBalance() {
        NM retVal = (NM)this.getTypedField(46, 0);
        return retVal;
    }

    public NM getPv146_CurrentPatientBalance() {
        NM retVal = (NM)this.getTypedField(46, 0);
        return retVal;
    }

    public NM getTotalCharges() {
        NM retVal = (NM)this.getTypedField(47, 0);
        return retVal;
    }

    public NM getPv147_TotalCharges() {
        NM retVal = (NM)this.getTypedField(47, 0);
        return retVal;
    }

    public NM getTotalAdjustments() {
        NM retVal = (NM)this.getTypedField(48, 0);
        return retVal;
    }

    public NM getPv148_TotalAdjustments() {
        NM retVal = (NM)this.getTypedField(48, 0);
        return retVal;
    }

    public NM getTotalPayments() {
        NM retVal = (NM)this.getTypedField(49, 0);
        return retVal;
    }

    public NM getPv149_TotalPayments() {
        NM retVal = (NM)this.getTypedField(49, 0);
        return retVal;
    }

    public CX[] getAlternateVisitID() {
        CX[] retVal = (CX[])this.getTypedField(50, (Type[])new CX[0]);
        return retVal;
    }

    public CX[] getPv150_AlternateVisitID() {
        CX[] retVal = (CX[])this.getTypedField(50, (Type[])new CX[0]);
        return retVal;
    }

    public int getAlternateVisitIDReps() {
        return this.getReps(50);
    }

    public CX getAlternateVisitID(int rep) {
        CX retVal = (CX)this.getTypedField(50, rep);
        return retVal;
    }

    public CX getPv150_AlternateVisitID(int rep) {
        CX retVal = (CX)this.getTypedField(50, rep);
        return retVal;
    }

    public int getPv150_AlternateVisitIDReps() {
        return this.getReps(50);
    }

    public CX insertAlternateVisitID(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(50, rep);
    }

    public CX insertPv150_AlternateVisitID(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(50, rep);
    }

    public CX removeAlternateVisitID(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(50, rep);
    }

    public CX removePv150_AlternateVisitID(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(50, rep);
    }

    public CWE getVisitIndicator() {
        CWE retVal = (CWE)this.getTypedField(51, 0);
        return retVal;
    }

    public CWE getPv151_VisitIndicator() {
        CWE retVal = (CWE)this.getTypedField(51, 0);
        return retVal;
    }

    public NULLDT getOtherHealthcareProvider() {
        NULLDT retVal = (NULLDT)this.getTypedField(52, 0);
        return retVal;
    }

    public NULLDT getPv152_OtherHealthcareProvider() {
        NULLDT retVal = (NULLDT)this.getTypedField(52, 0);
        return retVal;
    }

    public ST getServiceEpisodeDescription() {
        ST retVal = (ST)this.getTypedField(53, 0);
        return retVal;
    }

    public ST getPv153_ServiceEpisodeDescription() {
        ST retVal = (ST)this.getTypedField(53, 0);
        return retVal;
    }

    public CX getServiceEpisodeIdentifier() {
        CX retVal = (CX)this.getTypedField(54, 0);
        return retVal;
    }

    public CX getPv154_ServiceEpisodeIdentifier() {
        CX retVal = (CX)this.getTypedField(54, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new PL(this.getMessage());
            }
            case 3: {
                return new CWE(this.getMessage());
            }
            case 4: {
                return new CX(this.getMessage());
            }
            case 5: {
                return new PL(this.getMessage());
            }
            case 6: {
                return new XCN(this.getMessage());
            }
            case 7: {
                return new XCN(this.getMessage());
            }
            case 8: {
                return new XCN(this.getMessage());
            }
            case 9: {
                return new CWE(this.getMessage());
            }
            case 10: {
                return new PL(this.getMessage());
            }
            case 11: {
                return new CWE(this.getMessage());
            }
            case 12: {
                return new CWE(this.getMessage());
            }
            case 13: {
                return new CWE(this.getMessage());
            }
            case 14: {
                return new CWE(this.getMessage());
            }
            case 15: {
                return new CWE(this.getMessage());
            }
            case 16: {
                return new XCN(this.getMessage());
            }
            case 17: {
                return new CWE(this.getMessage());
            }
            case 18: {
                return new CX(this.getMessage());
            }
            case 19: {
                return new FC(this.getMessage());
            }
            case 20: {
                return new CWE(this.getMessage());
            }
            case 21: {
                return new CWE(this.getMessage());
            }
            case 22: {
                return new CWE(this.getMessage());
            }
            case 23: {
                return new CWE(this.getMessage());
            }
            case 24: {
                return new DT(this.getMessage());
            }
            case 25: {
                return new NM(this.getMessage());
            }
            case 26: {
                return new NM(this.getMessage());
            }
            case 27: {
                return new CWE(this.getMessage());
            }
            case 28: {
                return new CWE(this.getMessage());
            }
            case 29: {
                return new DT(this.getMessage());
            }
            case 30: {
                return new CWE(this.getMessage());
            }
            case 31: {
                return new NM(this.getMessage());
            }
            case 32: {
                return new NM(this.getMessage());
            }
            case 33: {
                return new CWE(this.getMessage());
            }
            case 34: {
                return new DT(this.getMessage());
            }
            case 35: {
                return new CWE(this.getMessage());
            }
            case 36: {
                return new DLD(this.getMessage());
            }
            case 37: {
                return new CWE(this.getMessage());
            }
            case 38: {
                return new CWE(this.getMessage());
            }
            case 39: {
                return new CWE(this.getMessage());
            }
            case 40: {
                return new CWE(this.getMessage());
            }
            case 41: {
                return new PL(this.getMessage());
            }
            case 42: {
                return new PL(this.getMessage());
            }
            case 43: {
                return new DTM(this.getMessage());
            }
            case 44: {
                return new DTM(this.getMessage());
            }
            case 45: {
                return new NM(this.getMessage());
            }
            case 46: {
                return new NM(this.getMessage());
            }
            case 47: {
                return new NM(this.getMessage());
            }
            case 48: {
                return new NM(this.getMessage());
            }
            case 49: {
                return new CX(this.getMessage());
            }
            case 50: {
                return new CWE(this.getMessage());
            }
            case 51: {
                return new NULLDT(this.getMessage());
            }
            case 52: {
                return new ST(this.getMessage());
            }
            case 53: {
                return new CX(this.getMessage());
            }
        }
        return null;
    }
}

