/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v28.datatype.CWE;
import ca.uhn.hl7v2.model.v28.datatype.EI;
import ca.uhn.hl7v2.model.v28.datatype.ID;
import ca.uhn.hl7v2.model.v28.datatype.NM;
import ca.uhn.hl7v2.model.v28.datatype.NULLDT;
import ca.uhn.hl7v2.model.v28.datatype.SN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class TCC
extends AbstractSegment {
    public TCC(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "Universal Service Identifier");
            this.add(EI.class, true, 1, 0, new Object[]{this.getMessage()}, "Equipment Test Application Identifier");
            this.add(NULLDT.class, false, 1, 0, new Object[]{this.getMessage()}, "Specimen Source");
            this.add(SN.class, false, 1, 0, new Object[]{this.getMessage()}, "Auto-Dilution Factor Default");
            this.add(SN.class, false, 1, 0, new Object[]{this.getMessage()}, "Rerun Dilution Factor Default");
            this.add(SN.class, false, 1, 0, new Object[]{this.getMessage()}, "Pre-Dilution Factor Default");
            this.add(SN.class, false, 1, 0, new Object[]{this.getMessage()}, "Endogenous Content of Pre-Dilution Diluent");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Inventory Limits Warning Level");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Automatic Rerun Allowed");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Automatic Repeat Allowed");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Automatic Reflex Allowed");
            this.add(SN.class, false, 1, 0, new Object[]{this.getMessage()}, "Equipment Dynamic Range");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Units");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Processing Type");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Test Criticality");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating TCC - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CWE getUniversalServiceIdentifier() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getTcc1_UniversalServiceIdentifier() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getEquipmentTestApplicationIdentifier() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public EI getTcc2_EquipmentTestApplicationIdentifier() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public NULLDT getSpecimenSource() {
        NULLDT retVal = (NULLDT)this.getTypedField(3, 0);
        return retVal;
    }

    public NULLDT getTcc3_SpecimenSource() {
        NULLDT retVal = (NULLDT)this.getTypedField(3, 0);
        return retVal;
    }

    public SN getAutoDilutionFactorDefault() {
        SN retVal = (SN)this.getTypedField(4, 0);
        return retVal;
    }

    public SN getTcc4_AutoDilutionFactorDefault() {
        SN retVal = (SN)this.getTypedField(4, 0);
        return retVal;
    }

    public SN getRerunDilutionFactorDefault() {
        SN retVal = (SN)this.getTypedField(5, 0);
        return retVal;
    }

    public SN getTcc5_RerunDilutionFactorDefault() {
        SN retVal = (SN)this.getTypedField(5, 0);
        return retVal;
    }

    public SN getPreDilutionFactorDefault() {
        SN retVal = (SN)this.getTypedField(6, 0);
        return retVal;
    }

    public SN getTcc6_PreDilutionFactorDefault() {
        SN retVal = (SN)this.getTypedField(6, 0);
        return retVal;
    }

    public SN getEndogenousContentOfPreDilutionDiluent() {
        SN retVal = (SN)this.getTypedField(7, 0);
        return retVal;
    }

    public SN getTcc7_EndogenousContentOfPreDilutionDiluent() {
        SN retVal = (SN)this.getTypedField(7, 0);
        return retVal;
    }

    public NM getInventoryLimitsWarningLevel() {
        NM retVal = (NM)this.getTypedField(8, 0);
        return retVal;
    }

    public NM getTcc8_InventoryLimitsWarningLevel() {
        NM retVal = (NM)this.getTypedField(8, 0);
        return retVal;
    }

    public ID getAutomaticRerunAllowed() {
        ID retVal = (ID)this.getTypedField(9, 0);
        return retVal;
    }

    public ID getTcc9_AutomaticRerunAllowed() {
        ID retVal = (ID)this.getTypedField(9, 0);
        return retVal;
    }

    public ID getAutomaticRepeatAllowed() {
        ID retVal = (ID)this.getTypedField(10, 0);
        return retVal;
    }

    public ID getTcc10_AutomaticRepeatAllowed() {
        ID retVal = (ID)this.getTypedField(10, 0);
        return retVal;
    }

    public ID getAutomaticReflexAllowed() {
        ID retVal = (ID)this.getTypedField(11, 0);
        return retVal;
    }

    public ID getTcc11_AutomaticReflexAllowed() {
        ID retVal = (ID)this.getTypedField(11, 0);
        return retVal;
    }

    public SN getEquipmentDynamicRange() {
        SN retVal = (SN)this.getTypedField(12, 0);
        return retVal;
    }

    public SN getTcc12_EquipmentDynamicRange() {
        SN retVal = (SN)this.getTypedField(12, 0);
        return retVal;
    }

    public CWE getUnits() {
        CWE retVal = (CWE)this.getTypedField(13, 0);
        return retVal;
    }

    public CWE getTcc13_Units() {
        CWE retVal = (CWE)this.getTypedField(13, 0);
        return retVal;
    }

    public CWE getProcessingType() {
        CWE retVal = (CWE)this.getTypedField(14, 0);
        return retVal;
    }

    public CWE getTcc14_ProcessingType() {
        CWE retVal = (CWE)this.getTypedField(14, 0);
        return retVal;
    }

    public CWE getTestCriticality() {
        CWE retVal = (CWE)this.getTypedField(15, 0);
        return retVal;
    }

    public CWE getTcc15_TestCriticality() {
        CWE retVal = (CWE)this.getTypedField(15, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CWE(this.getMessage());
            }
            case 1: {
                return new EI(this.getMessage());
            }
            case 2: {
                return new NULLDT(this.getMessage());
            }
            case 3: {
                return new SN(this.getMessage());
            }
            case 4: {
                return new SN(this.getMessage());
            }
            case 5: {
                return new SN(this.getMessage());
            }
            case 6: {
                return new SN(this.getMessage());
            }
            case 7: {
                return new NM(this.getMessage());
            }
            case 8: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 9: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 10: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 11: {
                return new SN(this.getMessage());
            }
            case 12: {
                return new CWE(this.getMessage());
            }
            case 13: {
                return new CWE(this.getMessage());
            }
            case 14: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

