/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v281.datatype.CWE;
import ca.uhn.hl7v2.model.v281.datatype.DTM;
import ca.uhn.hl7v2.model.v281.datatype.ID;

public class ICD
extends AbstractComposite {
    private Type[] data;

    public ICD(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[3];
        this.data[0] = new CWE(this.getMessage());
        this.data[1] = new ID(this.getMessage(), 136);
        this.data[2] = new DTM(this.getMessage());
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + ((Object)((Object)this)).getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public CWE getCertificationPatientType() {
        return (CWE)this.getTyped(0, CWE.class);
    }

    public CWE getIcd1_CertificationPatientType() {
        return (CWE)this.getTyped(0, CWE.class);
    }

    public ID getCertificationRequired() {
        return (ID)this.getTyped(1, ID.class);
    }

    public ID getIcd2_CertificationRequired() {
        return (ID)this.getTyped(1, ID.class);
    }

    public DTM getDateTimeCertificationRequired() {
        return (DTM)this.getTyped(2, DTM.class);
    }

    public DTM getIcd3_DateTimeCertificationRequired() {
        return (DTM)this.getTyped(2, DTM.class);
    }
}

