/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v281.group.BRP_O30_TIMING;
import ca.uhn.hl7v2.model.v281.segment.BPO;
import ca.uhn.hl7v2.model.v281.segment.BPX;
import ca.uhn.hl7v2.model.v281.segment.ORC;
import ca.uhn.hl7v2.model.v281.segment.PRT;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class BRP_O30_ORDER
extends AbstractGroup {
    public BRP_O30_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false, false);
            this.add(PRT.class, false, true, false);
            this.add(BRP_O30_TIMING.class, false, true, false);
            this.add(BPO.class, false, false, false);
            this.add(BPX.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating BRP_O30_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8.1";
    }

    public ORC getORC() {
        ORC retVal = (ORC)this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public PRT getPRT() {
        PRT retVal = (PRT)this.getTyped("PRT", PRT.class);
        return retVal;
    }

    public PRT getPRT(int rep) {
        PRT retVal = (PRT)this.getTyped("PRT", rep, PRT.class);
        return retVal;
    }

    public int getPRTReps() {
        return this.getReps("PRT");
    }

    public List<PRT> getPRTAll() throws HL7Exception {
        return this.getAllAsList("PRT", PRT.class);
    }

    public void insertPRT(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT", (Structure)structure, rep);
    }

    public PRT insertPRT(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT", rep);
    }

    public PRT removePRT(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT", rep);
    }

    public BRP_O30_TIMING getTIMING() {
        BRP_O30_TIMING retVal = (BRP_O30_TIMING)this.getTyped("TIMING", BRP_O30_TIMING.class);
        return retVal;
    }

    public BRP_O30_TIMING getTIMING(int rep) {
        BRP_O30_TIMING retVal = (BRP_O30_TIMING)this.getTyped("TIMING", rep, BRP_O30_TIMING.class);
        return retVal;
    }

    public int getTIMINGReps() {
        return this.getReps("TIMING");
    }

    public List<BRP_O30_TIMING> getTIMINGAll() throws HL7Exception {
        return this.getAllAsList("TIMING", BRP_O30_TIMING.class);
    }

    public void insertTIMING(BRP_O30_TIMING structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING", (Structure)structure, rep);
    }

    public BRP_O30_TIMING insertTIMING(int rep) throws HL7Exception {
        return (BRP_O30_TIMING)super.insertRepetition("TIMING", rep);
    }

    public BRP_O30_TIMING removeTIMING(int rep) throws HL7Exception {
        return (BRP_O30_TIMING)super.removeRepetition("TIMING", rep);
    }

    public BPO getBPO() {
        BPO retVal = (BPO)this.getTyped("BPO", BPO.class);
        return retVal;
    }

    public BPX getBPX() {
        BPX retVal = (BPX)this.getTyped("BPX", BPX.class);
        return retVal;
    }

    public BPX getBPX(int rep) {
        BPX retVal = (BPX)this.getTyped("BPX", rep, BPX.class);
        return retVal;
    }

    public int getBPXReps() {
        return this.getReps("BPX");
    }

    public List<BPX> getBPXAll() throws HL7Exception {
        return this.getAllAsList("BPX", BPX.class);
    }

    public void insertBPX(BPX structure, int rep) throws HL7Exception {
        super.insertRepetition("BPX", (Structure)structure, rep);
    }

    public BPX insertBPX(int rep) throws HL7Exception {
        return (BPX)super.insertRepetition("BPX", rep);
    }

    public BPX removeBPX(int rep) throws HL7Exception {
        return (BPX)super.removeRepetition("BPX", rep);
    }
}

