/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v281.group.CCR_I16_PATHWAY_OBSERVATION;
import ca.uhn.hl7v2.model.v281.group.CCR_I16_ROLE_PATHWAY;
import ca.uhn.hl7v2.model.v281.segment.PTH;
import ca.uhn.hl7v2.model.v281.segment.VAR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class CCR_I16_PATHWAY
extends AbstractGroup {
    public CCR_I16_PATHWAY(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PTH.class, true, false, false);
            this.add(VAR.class, false, true, false);
            this.add(CCR_I16_ROLE_PATHWAY.class, false, true, false);
            this.add(CCR_I16_PATHWAY_OBSERVATION.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating CCR_I16_PATHWAY - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8.1";
    }

    public PTH getPTH() {
        PTH retVal = (PTH)this.getTyped("PTH", PTH.class);
        return retVal;
    }

    public VAR getVAR() {
        VAR retVal = (VAR)this.getTyped("VAR", VAR.class);
        return retVal;
    }

    public VAR getVAR(int rep) {
        VAR retVal = (VAR)this.getTyped("VAR", rep, VAR.class);
        return retVal;
    }

    public int getVARReps() {
        return this.getReps("VAR");
    }

    public List<VAR> getVARAll() throws HL7Exception {
        return this.getAllAsList("VAR", VAR.class);
    }

    public void insertVAR(VAR structure, int rep) throws HL7Exception {
        super.insertRepetition("VAR", (Structure)structure, rep);
    }

    public VAR insertVAR(int rep) throws HL7Exception {
        return (VAR)super.insertRepetition("VAR", rep);
    }

    public VAR removeVAR(int rep) throws HL7Exception {
        return (VAR)super.removeRepetition("VAR", rep);
    }

    public CCR_I16_ROLE_PATHWAY getROLE_PATHWAY() {
        CCR_I16_ROLE_PATHWAY retVal = (CCR_I16_ROLE_PATHWAY)this.getTyped("ROLE_PATHWAY", CCR_I16_ROLE_PATHWAY.class);
        return retVal;
    }

    public CCR_I16_ROLE_PATHWAY getROLE_PATHWAY(int rep) {
        CCR_I16_ROLE_PATHWAY retVal = (CCR_I16_ROLE_PATHWAY)this.getTyped("ROLE_PATHWAY", rep, CCR_I16_ROLE_PATHWAY.class);
        return retVal;
    }

    public int getROLE_PATHWAYReps() {
        return this.getReps("ROLE_PATHWAY");
    }

    public List<CCR_I16_ROLE_PATHWAY> getROLE_PATHWAYAll() throws HL7Exception {
        return this.getAllAsList("ROLE_PATHWAY", CCR_I16_ROLE_PATHWAY.class);
    }

    public void insertROLE_PATHWAY(CCR_I16_ROLE_PATHWAY structure, int rep) throws HL7Exception {
        super.insertRepetition("ROLE_PATHWAY", (Structure)structure, rep);
    }

    public CCR_I16_ROLE_PATHWAY insertROLE_PATHWAY(int rep) throws HL7Exception {
        return (CCR_I16_ROLE_PATHWAY)super.insertRepetition("ROLE_PATHWAY", rep);
    }

    public CCR_I16_ROLE_PATHWAY removeROLE_PATHWAY(int rep) throws HL7Exception {
        return (CCR_I16_ROLE_PATHWAY)super.removeRepetition("ROLE_PATHWAY", rep);
    }

    public CCR_I16_PATHWAY_OBSERVATION getPATHWAY_OBSERVATION() {
        CCR_I16_PATHWAY_OBSERVATION retVal = (CCR_I16_PATHWAY_OBSERVATION)this.getTyped("PATHWAY_OBSERVATION", CCR_I16_PATHWAY_OBSERVATION.class);
        return retVal;
    }

    public CCR_I16_PATHWAY_OBSERVATION getPATHWAY_OBSERVATION(int rep) {
        CCR_I16_PATHWAY_OBSERVATION retVal = (CCR_I16_PATHWAY_OBSERVATION)this.getTyped("PATHWAY_OBSERVATION", rep, CCR_I16_PATHWAY_OBSERVATION.class);
        return retVal;
    }

    public int getPATHWAY_OBSERVATIONReps() {
        return this.getReps("PATHWAY_OBSERVATION");
    }

    public List<CCR_I16_PATHWAY_OBSERVATION> getPATHWAY_OBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("PATHWAY_OBSERVATION", CCR_I16_PATHWAY_OBSERVATION.class);
    }

    public void insertPATHWAY_OBSERVATION(CCR_I16_PATHWAY_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("PATHWAY_OBSERVATION", (Structure)structure, rep);
    }

    public CCR_I16_PATHWAY_OBSERVATION insertPATHWAY_OBSERVATION(int rep) throws HL7Exception {
        return (CCR_I16_PATHWAY_OBSERVATION)super.insertRepetition("PATHWAY_OBSERVATION", rep);
    }

    public CCR_I16_PATHWAY_OBSERVATION removePATHWAY_OBSERVATION(int rep) throws HL7Exception {
        return (CCR_I16_PATHWAY_OBSERVATION)super.removeRepetition("PATHWAY_OBSERVATION", rep);
    }
}

