/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v281.group.OSM_R26_PACKAGE;
import ca.uhn.hl7v2.model.v281.group.OSM_R26_SHIPPING_OBSERVATION;
import ca.uhn.hl7v2.model.v281.segment.PRT;
import ca.uhn.hl7v2.model.v281.segment.SHP;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class OSM_R26_SHIPMENT
extends AbstractGroup {
    public OSM_R26_SHIPMENT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SHP.class, true, false, false);
            this.add(PRT.class, true, true, false);
            this.add(OSM_R26_SHIPPING_OBSERVATION.class, false, true, false);
            this.add(OSM_R26_PACKAGE.class, true, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OSM_R26_SHIPMENT - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8.1";
    }

    public SHP getSHP() {
        SHP retVal = (SHP)this.getTyped("SHP", SHP.class);
        return retVal;
    }

    public PRT getPRT() {
        PRT retVal = (PRT)this.getTyped("PRT", PRT.class);
        return retVal;
    }

    public PRT getPRT(int rep) {
        PRT retVal = (PRT)this.getTyped("PRT", rep, PRT.class);
        return retVal;
    }

    public int getPRTReps() {
        return this.getReps("PRT");
    }

    public List<PRT> getPRTAll() throws HL7Exception {
        return this.getAllAsList("PRT", PRT.class);
    }

    public void insertPRT(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT", (Structure)structure, rep);
    }

    public PRT insertPRT(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT", rep);
    }

    public PRT removePRT(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT", rep);
    }

    public OSM_R26_SHIPPING_OBSERVATION getSHIPPING_OBSERVATION() {
        OSM_R26_SHIPPING_OBSERVATION retVal = (OSM_R26_SHIPPING_OBSERVATION)this.getTyped("SHIPPING_OBSERVATION", OSM_R26_SHIPPING_OBSERVATION.class);
        return retVal;
    }

    public OSM_R26_SHIPPING_OBSERVATION getSHIPPING_OBSERVATION(int rep) {
        OSM_R26_SHIPPING_OBSERVATION retVal = (OSM_R26_SHIPPING_OBSERVATION)this.getTyped("SHIPPING_OBSERVATION", rep, OSM_R26_SHIPPING_OBSERVATION.class);
        return retVal;
    }

    public int getSHIPPING_OBSERVATIONReps() {
        return this.getReps("SHIPPING_OBSERVATION");
    }

    public List<OSM_R26_SHIPPING_OBSERVATION> getSHIPPING_OBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("SHIPPING_OBSERVATION", OSM_R26_SHIPPING_OBSERVATION.class);
    }

    public void insertSHIPPING_OBSERVATION(OSM_R26_SHIPPING_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("SHIPPING_OBSERVATION", (Structure)structure, rep);
    }

    public OSM_R26_SHIPPING_OBSERVATION insertSHIPPING_OBSERVATION(int rep) throws HL7Exception {
        return (OSM_R26_SHIPPING_OBSERVATION)super.insertRepetition("SHIPPING_OBSERVATION", rep);
    }

    public OSM_R26_SHIPPING_OBSERVATION removeSHIPPING_OBSERVATION(int rep) throws HL7Exception {
        return (OSM_R26_SHIPPING_OBSERVATION)super.removeRepetition("SHIPPING_OBSERVATION", rep);
    }

    public OSM_R26_PACKAGE getPACKAGE() {
        OSM_R26_PACKAGE retVal = (OSM_R26_PACKAGE)this.getTyped("PACKAGE", OSM_R26_PACKAGE.class);
        return retVal;
    }

    public OSM_R26_PACKAGE getPACKAGE(int rep) {
        OSM_R26_PACKAGE retVal = (OSM_R26_PACKAGE)this.getTyped("PACKAGE", rep, OSM_R26_PACKAGE.class);
        return retVal;
    }

    public int getPACKAGEReps() {
        return this.getReps("PACKAGE");
    }

    public List<OSM_R26_PACKAGE> getPACKAGEAll() throws HL7Exception {
        return this.getAllAsList("PACKAGE", OSM_R26_PACKAGE.class);
    }

    public void insertPACKAGE(OSM_R26_PACKAGE structure, int rep) throws HL7Exception {
        super.insertRepetition("PACKAGE", (Structure)structure, rep);
    }

    public OSM_R26_PACKAGE insertPACKAGE(int rep) throws HL7Exception {
        return (OSM_R26_PACKAGE)super.insertRepetition("PACKAGE", rep);
    }

    public OSM_R26_PACKAGE removePACKAGE(int rep) throws HL7Exception {
        return (OSM_R26_PACKAGE)super.removeRepetition("PACKAGE", rep);
    }
}

