/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v281.segment.ARV;
import ca.uhn.hl7v2.model.v281.segment.PV1;
import ca.uhn.hl7v2.model.v281.segment.PV2;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class VXU_V04_PATIENT_VISIT
extends AbstractGroup {
    public VXU_V04_PATIENT_VISIT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PV1.class, true, false, false);
            this.add(PV2.class, false, false, false);
            this.add(ARV.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating VXU_V04_PATIENT_VISIT - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8.1";
    }

    public PV1 getPV1() {
        PV1 retVal = (PV1)this.getTyped("PV1", PV1.class);
        return retVal;
    }

    public PV2 getPV2() {
        PV2 retVal = (PV2)this.getTyped("PV2", PV2.class);
        return retVal;
    }

    public ARV getARV() {
        ARV retVal = (ARV)this.getTyped("ARV", ARV.class);
        return retVal;
    }

    public ARV getARV(int rep) {
        ARV retVal = (ARV)this.getTyped("ARV", rep, ARV.class);
        return retVal;
    }

    public int getARVReps() {
        return this.getReps("ARV");
    }

    public List<ARV> getARVAll() throws HL7Exception {
        return this.getAllAsList("ARV", ARV.class);
    }

    public void insertARV(ARV structure, int rep) throws HL7Exception {
        super.insertRepetition("ARV", (Structure)structure, rep);
    }

    public ARV insertARV(int rep) throws HL7Exception {
        return (ARV)super.insertRepetition("ARV", rep);
    }

    public ARV removeARV(int rep) throws HL7Exception {
        return (ARV)super.removeRepetition("ARV", rep);
    }
}

