/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v281.group.ORU_R30_OBSERVATION;
import ca.uhn.hl7v2.model.v281.group.ORU_R30_PATIENT_OBSERVATION;
import ca.uhn.hl7v2.model.v281.group.ORU_R30_TIMING_QTY;
import ca.uhn.hl7v2.model.v281.group.ORU_R30_VISIT;
import ca.uhn.hl7v2.model.v281.segment.ARV;
import ca.uhn.hl7v2.model.v281.segment.MSH;
import ca.uhn.hl7v2.model.v281.segment.NTE;
import ca.uhn.hl7v2.model.v281.segment.OBR;
import ca.uhn.hl7v2.model.v281.segment.ORC;
import ca.uhn.hl7v2.model.v281.segment.PD1;
import ca.uhn.hl7v2.model.v281.segment.PID;
import ca.uhn.hl7v2.model.v281.segment.PRT;
import ca.uhn.hl7v2.model.v281.segment.SFT;
import ca.uhn.hl7v2.model.v281.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class ORU_R30
extends AbstractMessage {
    public ORU_R30() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public ORU_R30(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(PID.class, true, false);
            this.add(PD1.class, false, false);
            this.add(PRT.class, false, true);
            this.add(ARV.class, false, true);
            this.add(ORU_R30_PATIENT_OBSERVATION.class, false, true);
            this.add(ORU_R30_VISIT.class, false, false);
            this.add(ORC.class, true, false);
            this.add(PRT.class, false, true);
            this.add(OBR.class, true, false);
            this.add(NTE.class, false, true);
            this.add(PRT.class, false, true);
            this.add(ORU_R30_TIMING_QTY.class, false, true);
            this.add(ORU_R30_OBSERVATION.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ORU_R30 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8.1";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return (UAC)this.getTyped("UAC", UAC.class);
    }

    public PID getPID() {
        return (PID)this.getTyped("PID", PID.class);
    }

    public PD1 getPD1() {
        return (PD1)this.getTyped("PD1", PD1.class);
    }

    public PRT getPRT() {
        return (PRT)this.getTyped("PRT", PRT.class);
    }

    public PRT getPRT(int rep) {
        return (PRT)this.getTyped("PRT", rep, PRT.class);
    }

    public int getPRTReps() {
        return this.getReps("PRT");
    }

    public List<PRT> getPRTAll() throws HL7Exception {
        return this.getAllAsList("PRT", PRT.class);
    }

    public void insertPRT(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT", (Structure)structure, rep);
    }

    public PRT insertPRT(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT", rep);
    }

    public PRT removePRT(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT", rep);
    }

    public ARV getARV() {
        return (ARV)this.getTyped("ARV", ARV.class);
    }

    public ARV getARV(int rep) {
        return (ARV)this.getTyped("ARV", rep, ARV.class);
    }

    public int getARVReps() {
        return this.getReps("ARV");
    }

    public List<ARV> getARVAll() throws HL7Exception {
        return this.getAllAsList("ARV", ARV.class);
    }

    public void insertARV(ARV structure, int rep) throws HL7Exception {
        super.insertRepetition("ARV", (Structure)structure, rep);
    }

    public ARV insertARV(int rep) throws HL7Exception {
        return (ARV)super.insertRepetition("ARV", rep);
    }

    public ARV removeARV(int rep) throws HL7Exception {
        return (ARV)super.removeRepetition("ARV", rep);
    }

    public ORU_R30_PATIENT_OBSERVATION getPATIENT_OBSERVATION() {
        return (ORU_R30_PATIENT_OBSERVATION)this.getTyped("PATIENT_OBSERVATION", ORU_R30_PATIENT_OBSERVATION.class);
    }

    public ORU_R30_PATIENT_OBSERVATION getPATIENT_OBSERVATION(int rep) {
        return (ORU_R30_PATIENT_OBSERVATION)this.getTyped("PATIENT_OBSERVATION", rep, ORU_R30_PATIENT_OBSERVATION.class);
    }

    public int getPATIENT_OBSERVATIONReps() {
        return this.getReps("PATIENT_OBSERVATION");
    }

    public List<ORU_R30_PATIENT_OBSERVATION> getPATIENT_OBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("PATIENT_OBSERVATION", ORU_R30_PATIENT_OBSERVATION.class);
    }

    public void insertPATIENT_OBSERVATION(ORU_R30_PATIENT_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("PATIENT_OBSERVATION", (Structure)structure, rep);
    }

    public ORU_R30_PATIENT_OBSERVATION insertPATIENT_OBSERVATION(int rep) throws HL7Exception {
        return (ORU_R30_PATIENT_OBSERVATION)super.insertRepetition("PATIENT_OBSERVATION", rep);
    }

    public ORU_R30_PATIENT_OBSERVATION removePATIENT_OBSERVATION(int rep) throws HL7Exception {
        return (ORU_R30_PATIENT_OBSERVATION)super.removeRepetition("PATIENT_OBSERVATION", rep);
    }

    public ORU_R30_VISIT getVISIT() {
        return (ORU_R30_VISIT)this.getTyped("VISIT", ORU_R30_VISIT.class);
    }

    public ORC getORC() {
        return (ORC)this.getTyped("ORC", ORC.class);
    }

    public PRT getPRT2() {
        return (PRT)this.getTyped("PRT2", PRT.class);
    }

    public PRT getPRT2(int rep) {
        return (PRT)this.getTyped("PRT2", rep, PRT.class);
    }

    public int getPRT2Reps() {
        return this.getReps("PRT2");
    }

    public List<PRT> getPRT2All() throws HL7Exception {
        return this.getAllAsList("PRT2", PRT.class);
    }

    public void insertPRT2(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT2", (Structure)structure, rep);
    }

    public PRT insertPRT2(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT2", rep);
    }

    public PRT removePRT2(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT2", rep);
    }

    public OBR getOBR() {
        return (OBR)this.getTyped("OBR", OBR.class);
    }

    public NTE getNTE() {
        return (NTE)this.getTyped("NTE", NTE.class);
    }

    public NTE getNTE(int rep) {
        return (NTE)this.getTyped("NTE", rep, NTE.class);
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public PRT getPRT3() {
        return (PRT)this.getTyped("PRT3", PRT.class);
    }

    public PRT getPRT3(int rep) {
        return (PRT)this.getTyped("PRT3", rep, PRT.class);
    }

    public int getPRT3Reps() {
        return this.getReps("PRT3");
    }

    public List<PRT> getPRT3All() throws HL7Exception {
        return this.getAllAsList("PRT3", PRT.class);
    }

    public void insertPRT3(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT3", (Structure)structure, rep);
    }

    public PRT insertPRT3(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT3", rep);
    }

    public PRT removePRT3(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT3", rep);
    }

    public ORU_R30_TIMING_QTY getTIMING_QTY() {
        return (ORU_R30_TIMING_QTY)this.getTyped("TIMING_QTY", ORU_R30_TIMING_QTY.class);
    }

    public ORU_R30_TIMING_QTY getTIMING_QTY(int rep) {
        return (ORU_R30_TIMING_QTY)this.getTyped("TIMING_QTY", rep, ORU_R30_TIMING_QTY.class);
    }

    public int getTIMING_QTYReps() {
        return this.getReps("TIMING_QTY");
    }

    public List<ORU_R30_TIMING_QTY> getTIMING_QTYAll() throws HL7Exception {
        return this.getAllAsList("TIMING_QTY", ORU_R30_TIMING_QTY.class);
    }

    public void insertTIMING_QTY(ORU_R30_TIMING_QTY structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING_QTY", (Structure)structure, rep);
    }

    public ORU_R30_TIMING_QTY insertTIMING_QTY(int rep) throws HL7Exception {
        return (ORU_R30_TIMING_QTY)super.insertRepetition("TIMING_QTY", rep);
    }

    public ORU_R30_TIMING_QTY removeTIMING_QTY(int rep) throws HL7Exception {
        return (ORU_R30_TIMING_QTY)super.removeRepetition("TIMING_QTY", rep);
    }

    public ORU_R30_OBSERVATION getOBSERVATION() {
        return (ORU_R30_OBSERVATION)this.getTyped("OBSERVATION", ORU_R30_OBSERVATION.class);
    }

    public ORU_R30_OBSERVATION getOBSERVATION(int rep) {
        return (ORU_R30_OBSERVATION)this.getTyped("OBSERVATION", rep, ORU_R30_OBSERVATION.class);
    }

    public int getOBSERVATIONReps() {
        return this.getReps("OBSERVATION");
    }

    public List<ORU_R30_OBSERVATION> getOBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("OBSERVATION", ORU_R30_OBSERVATION.class);
    }

    public void insertOBSERVATION(ORU_R30_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", (Structure)structure, rep);
    }

    public ORU_R30_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (ORU_R30_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public ORU_R30_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (ORU_R30_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }
}

