/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.tomcat;

import ch.qos.logback.access.joran.JoranConfigurator;
import ch.qos.logback.access.spi.AccessEvent;
import ch.qos.logback.access.tomcat.TomcatServerAdapter;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.BasicStatusManager;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.spi.AppenderAttachable;
import ch.qos.logback.core.spi.AppenderAttachableImpl;
import ch.qos.logback.core.spi.FilterAttachable;
import ch.qos.logback.core.spi.FilterAttachableImpl;
import ch.qos.logback.core.spi.FilterReply;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.status.WarnStatus;
import ch.qos.logback.core.util.OptionHelper;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogbackValve
extends ValveBase
implements Lifecycle,
Context,
AppenderAttachable<AccessEvent>,
FilterAttachable {
    public static final String DEFAULT_CONFIG_FILE = "conf" + File.separatorChar + "logback-access.xml";
    private String name;
    StatusManager sm = new BasicStatusManager();
    Map<String, String> propertyMap = new HashMap<String, String>();
    Map<String, Object> objectMap = new HashMap<String, Object>();
    private FilterAttachableImpl fai = new FilterAttachableImpl();
    AppenderAttachableImpl<AccessEvent> aai = new AppenderAttachableImpl();
    String filename;
    boolean quiet;
    boolean started;

    public LogbackValve() {
        this.putObject("EVALUATOR_MAP", new HashMap());
    }

    public void start() {
        File configFile;
        if (this.filename == null) {
            String tomcatHomeProperty = OptionHelper.getSystemProperty((String)"catalina.home");
            this.filename = tomcatHomeProperty + File.separatorChar + DEFAULT_CONFIG_FILE;
            this.getStatusManager().add((Status)new InfoStatus("filename property not set. Assuming [" + this.filename + "]", (Object)this));
        }
        if ((configFile = new File(this.filename)).exists()) {
            try {
                JoranConfigurator jc = new JoranConfigurator();
                jc.setContext(this);
                jc.doConfigure(this.filename);
            }
            catch (JoranException e) {
                e.printStackTrace();
            }
        } else {
            this.getStatusManager().add((Status)new WarnStatus("[" + this.filename + "] does not exist", (Object)this));
        }
        if (!this.quiet) {
            StatusPrinter.print((StatusManager)this.getStatusManager());
        }
        this.started = true;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.getNext().invoke(request, response);
        TomcatServerAdapter adapter = new TomcatServerAdapter(request, response);
        AccessEvent accessEvent = new AccessEvent((HttpServletRequest)request, (HttpServletResponse)response, adapter);
        if (this.getFilterChainDecision(accessEvent) == FilterReply.DENY) {
            return;
        }
        this.aai.appendLoopOnAppenders((Object)accessEvent);
    }

    public void stop() {
        this.started = false;
    }

    public void addAppender(Appender<AccessEvent> newAppender) {
        this.aai.addAppender(newAppender);
    }

    public Iterator<Appender<AccessEvent>> iteratorForAppenders() {
        return this.aai.iteratorForAppenders();
    }

    public Appender<AccessEvent> getAppender(String name) {
        return this.aai.getAppender(name);
    }

    public boolean isAttached(Appender appender) {
        return this.aai.isAttached(appender);
    }

    public void detachAndStopAllAppenders() {
        this.aai.detachAndStopAllAppenders();
    }

    public boolean detachAppender(Appender appender) {
        return this.aai.detachAppender(appender);
    }

    public boolean detachAppender(String name) {
        return this.aai.detachAppender(name);
    }

    public String getInfo() {
        return "Logback's implementation of ValveBase";
    }

    public StatusManager getStatusManager() {
        return this.sm;
    }

    public Map<String, String> getPropertyMap() {
        return this.propertyMap;
    }

    public void putProperty(String key, String val) {
        this.propertyMap.put(key, val);
    }

    public String getProperty(String key) {
        return this.propertyMap.get(key);
    }

    public Object getObject(String key) {
        return this.objectMap.get(key);
    }

    public void putObject(String key, Object value) {
        this.objectMap.put(key, value);
    }

    public void addFilter(Filter newFilter) {
        this.fai.addFilter(newFilter);
    }

    public Filter getFirstFilter() {
        return this.fai.getFirstFilter();
    }

    public void clearAllFilters() {
        this.fai.clearAllFilters();
    }

    public FilterReply getFilterChainDecision(Object event) {
        return this.fai.getFilterChainDecision(event);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.name != null) {
            throw new IllegalStateException("LogbackValve has been already given a name");
        }
        this.name = name;
    }

    public void addLifecycleListener(LifecycleListener arg0) {
    }

    public LifecycleListener[] findLifecycleListeners() {
        return new LifecycleListener[0];
    }

    public void removeLifecycleListener(LifecycleListener arg0) {
    }
}

