/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.joran;

import ch.qos.logback.access.PatternLayout;
import ch.qos.logback.access.PatternLayoutEncoder;
import ch.qos.logback.access.boolex.JaninoEventEvaluator;
import ch.qos.logback.access.joran.action.ConfigurationAction;
import ch.qos.logback.access.model.ConfigurationModel;
import ch.qos.logback.access.model.processor.ConfigurationModelHandler;
import ch.qos.logback.access.spi.IAccessEvent;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.filter.EvaluatorFilter;
import ch.qos.logback.core.joran.JoranConfiguratorBase;
import ch.qos.logback.core.joran.action.AppenderRefAction;
import ch.qos.logback.core.joran.action.IncludeAction;
import ch.qos.logback.core.joran.spi.DefaultNestedComponentRegistry;
import ch.qos.logback.core.joran.spi.ElementSelector;
import ch.qos.logback.core.joran.spi.RuleStore;
import ch.qos.logback.core.model.AppenderModel;
import ch.qos.logback.core.model.AppenderRefModel;
import ch.qos.logback.core.model.DefineModel;
import ch.qos.logback.core.model.EventEvaluatorModel;
import ch.qos.logback.core.model.ImplicitModel;
import ch.qos.logback.core.model.ImportModel;
import ch.qos.logback.core.model.IncludeModel;
import ch.qos.logback.core.model.ParamModel;
import ch.qos.logback.core.model.PropertyModel;
import ch.qos.logback.core.model.ShutdownHookModel;
import ch.qos.logback.core.model.TimestampModel;
import ch.qos.logback.core.model.conditional.ElseModel;
import ch.qos.logback.core.model.conditional.IfModel;
import ch.qos.logback.core.model.conditional.ThenModel;
import ch.qos.logback.core.model.processor.AllowAllModelFilter;
import ch.qos.logback.core.model.processor.AppenderModelHandler;
import ch.qos.logback.core.model.processor.AppenderRefDependencyAnalyser;
import ch.qos.logback.core.model.processor.AppenderRefModelHandler;
import ch.qos.logback.core.model.processor.ChainedModelFilter;
import ch.qos.logback.core.model.processor.DefaultProcessor;
import ch.qos.logback.core.model.processor.ModelFilter;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.model.processor.RefContainerDependencyAnalyser;
import ch.qos.logback.core.net.ssl.SSLNestedComponentRegistryRules;

public class JoranConfigurator
extends JoranConfiguratorBase<IAccessEvent> {
    public void addInstanceRules(RuleStore rs) {
        super.addInstanceRules(rs);
        rs.addRule(new ElementSelector("configuration"), () -> new ConfigurationAction());
        rs.addRule(new ElementSelector("configuration/appender-ref"), () -> new AppenderRefAction());
        rs.addRule(new ElementSelector("configuration/include"), () -> new IncludeAction());
    }

    protected DefaultProcessor buildDefaultProcessor(Context context, ModelInterpretationContext mic) {
        DefaultProcessor defaultProcessor = super.buildDefaultProcessor(context, mic);
        defaultProcessor.addHandler(ConfigurationModel.class, ConfigurationModelHandler::makeInstance);
        defaultProcessor.addHandler(AppenderModel.class, AppenderModelHandler::makeInstance);
        defaultProcessor.addHandler(AppenderRefModel.class, AppenderRefModelHandler::makeInstance);
        defaultProcessor.addAnalyser(AppenderModel.class, (ModelHandlerBase)new RefContainerDependencyAnalyser(context, AppenderModel.class));
        defaultProcessor.addAnalyser(AppenderRefModel.class, (ModelHandlerBase)new AppenderRefDependencyAnalyser(context));
        this.injectModelFilters(defaultProcessor);
        return defaultProcessor;
    }

    private void injectModelFilters(DefaultProcessor defaultProcessor) {
        Class[] importModelClasses = new Class[]{ImportModel.class};
        Class[] variableDefinitionModelClasses = new Class[]{DefineModel.class, PropertyModel.class, TimestampModel.class, ParamModel.class};
        Class[] implicitModelClasses = new Class[]{ImplicitModel.class, ParamModel.class};
        Class[] otherFirstPhaseModelClasses = new Class[]{ConfigurationModel.class, EventEvaluatorModel.class, ShutdownHookModel.class, EventEvaluatorModel.class, IncludeModel.class, IfModel.class, ThenModel.class, ElseModel.class};
        ChainedModelFilter fistPhaseDefintionFilter = new ChainedModelFilter();
        for (Class modelClass : importModelClasses) {
            fistPhaseDefintionFilter.allow(modelClass);
        }
        for (Class modelClass : variableDefinitionModelClasses) {
            fistPhaseDefintionFilter.allow(modelClass);
        }
        for (Class modelClass : otherFirstPhaseModelClasses) {
            fistPhaseDefintionFilter.allow(modelClass);
        }
        for (Class modelClass : implicitModelClasses) {
            fistPhaseDefintionFilter.allow(modelClass);
        }
        fistPhaseDefintionFilter.denyAll();
        defaultProcessor.setPhaseOneFilter((ModelFilter)fistPhaseDefintionFilter);
        defaultProcessor.setPhaseTwoFilter((ModelFilter)new AllowAllModelFilter());
    }

    protected void addDefaultNestedComponentRegistryRules(DefaultNestedComponentRegistry registry) {
        registry.add(AppenderBase.class, "layout", PatternLayout.class);
        registry.add(EvaluatorFilter.class, "evaluator", JaninoEventEvaluator.class);
        registry.add(AppenderBase.class, "encoder", PatternLayoutEncoder.class);
        registry.add(UnsynchronizedAppenderBase.class, "encoder", PatternLayoutEncoder.class);
        SSLNestedComponentRegistryRules.addDefaultNestedComponentRegistryRules((DefaultNestedComponentRegistry)registry);
    }
}

