/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.CallerData;
import ch.qos.logback.classic.spi.ThrowableInformation;
import org.slf4j.Logger;
import org.slf4j.Marker;

public class LoggingEvent {
    private static long startTime = System.currentTimeMillis();
    transient String fqnOfLoggerClass;
    private String threadName;
    private Level level;
    private String message;
    private Object[] argumentArray;
    private Logger logger;
    private ThrowableInformation throwableInfo;
    private CallerData[] callerDataArray;
    private Marker marker;
    private long timeStamp;

    public LoggingEvent(String fqcn, Logger logger, Level level, String message, Throwable throwable) {
        this.fqnOfLoggerClass = fqcn;
        this.logger = logger;
        this.level = level;
        this.message = message;
        if (throwable != null) {
            this.throwableInfo = new ThrowableInformation(throwable);
        }
        this.timeStamp = System.currentTimeMillis();
    }

    public void setArgumentArray(Object[] argArray) {
        if (this.argumentArray != null) {
            throw new IllegalStateException("argArray has been already set");
        }
        this.argumentArray = argArray;
    }

    public Object[] getArgumentArray() {
        return this.argumentArray;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getThreadName() {
        if (this.threadName == null) {
            this.threadName = Thread.currentThread().getName();
        }
        return this.threadName;
    }

    public void setThreadName(String threadName) throws IllegalStateException {
        if (this.threadName != null) {
            throw new IllegalStateException("threadName has been already set");
        }
        this.threadName = threadName;
    }

    public ThrowableInformation getThrowableInformation() {
        return this.throwableInfo;
    }

    public void setThrowableInformation(ThrowableInformation ti) {
        if (this.throwableInfo != null) {
            throw new IllegalStateException("ThrowableInformation has been already set.");
        }
        this.throwableInfo = ti;
    }

    public void prepareForDeferredProcessing() {
        this.getThreadName();
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        if (this.message != null) {
            throw new IllegalStateException("The message for this event has been set alredy.");
        }
        this.message = message;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public void setLevel(Level level) {
        if (this.level != null) {
            throw new IllegalStateException("The level has been already set for this event.");
        }
        this.level = level;
    }

    public static final long getStartTime() {
        return startTime;
    }

    public CallerData[] getCallerData() {
        if (this.callerDataArray == null && this.fqnOfLoggerClass != null) {
            this.callerDataArray = CallerData.extract(new Throwable(), this.fqnOfLoggerClass);
        }
        return this.callerDataArray;
    }

    public void setCallerInformation(CallerData[] callerDataArray) {
        this.callerDataArray = callerDataArray;
    }

    public Marker getMarker() {
        return this.marker;
    }

    public void setMarker(Marker marker) {
        if (this.marker != null) {
            throw new IllegalStateException("The marker has been already set for this event.");
        }
        this.marker = marker;
    }
}

