/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.turbo;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.spi.FilterReply;
import java.io.File;
import java.net.URL;
import org.slf4j.Marker;

public class ReconfigureOnChangeFilter
extends TurboFilter {
    static final long INIT = System.currentTimeMillis();
    static final long SENTINEL = Long.MAX_VALUE;
    public static final long DEFAULT_REFRESH_PERIOD = 60000L;
    long refreshPeriod = 60000L;
    File fileToScan;
    protected long nextCheck;
    long lastModified;
    private int invocationCounter = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        URL url = (URL)this.context.getObject(CoreConstants.URL_OF_LAST_CONFIGURATION_VIA_JORAN);
        if (url != null) {
            this.fileToScan = this.convertToFile(url);
            if (this.fileToScan != null) {
                Context context = this.context;
                synchronized (context) {
                    long inSeconds = this.refreshPeriod / 1000L;
                    this.addInfo("Will scan for changes in file [" + this.fileToScan + "] every " + inSeconds + " seconds. ");
                    this.lastModified = this.fileToScan.lastModified();
                    this.updateNextCheck(System.currentTimeMillis());
                }
                super.start();
            }
        } else {
            this.addError("Could not find URL of file to scan.");
        }
    }

    File convertToFile(URL url) {
        String protocol = url.getProtocol();
        if ("file".equals(protocol)) {
            File file = new File(url.getFile());
            return file;
        }
        this.addError("URL [" + url + "] is not of type file");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterReply decide(Marker marker, Logger logger, Level level, String format, Object[] params, Throwable t) {
        if (!this.isStarted()) {
            return FilterReply.NEUTRAL;
        }
        if ((this.invocationCounter++ & 0xF) != 15) {
            return FilterReply.NEUTRAL;
        }
        Context context = this.context;
        synchronized (context) {
            boolean changed = this.changeDetected();
            if (changed) {
                this.addInfo("Detected change in [" + this.fileToScan + "]");
                this.addInfo("Resetting and reconfiguring context [" + this.context.getName() + "]");
                this.reconfigure();
            }
        }
        return FilterReply.NEUTRAL;
    }

    void updateNextCheck(long now) {
        this.nextCheck = now + this.refreshPeriod;
    }

    protected boolean changeDetected() {
        long now = System.currentTimeMillis();
        if (now >= this.nextCheck) {
            this.updateNextCheck(now);
            return this.lastModified != this.fileToScan.lastModified() && this.lastModified != Long.MAX_VALUE;
        }
        return false;
    }

    String currentThreadName() {
        return Thread.currentThread().getName();
    }

    void disableSubsequentRecofiguration() {
        this.lastModified = Long.MAX_VALUE;
    }

    protected void reconfigure() {
        this.disableSubsequentRecofiguration();
        JoranConfigurator jc = new JoranConfigurator();
        jc.setContext(this.context);
        LoggerContext lc = (LoggerContext)this.context;
        lc.reset();
        try {
            jc.doConfigure(this.fileToScan);
        }
        catch (JoranException e) {
            this.addError("Failure during reconfiguration", e);
        }
    }

    public long getRefreshPeriod() {
        return this.refreshPeriod;
    }

    public void setRefreshPeriod(long refreshPeriod) {
        this.refreshPeriod = refreshPeriod;
    }
}

