/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.encoder;

import ch.qos.logback.core.encoder.EventObjectInputStream;
import ch.qos.logback.core.encoder.ObjectStreamEncoder;
import ch.qos.logback.core.testUtil.RandomUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectEncodeDecodeTest {
    ObjectStreamEncoder<String> encoder = new ObjectStreamEncoder();
    EventObjectInputStream<String> eventStream;
    int diff = RandomUtil.getPositiveInt();
    protected String randomOutputDir = "target/test-output/" + this.diff + "/";

    @Before
    public void setUp() {
        File randomOupurDirFile = new File(this.randomOutputDir);
        randomOupurDirFile.mkdirs();
    }

    void encodeList(File file, List<String> list) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        this.encoder.init((OutputStream)fos);
        for (String s : list) {
            this.encoder.doEncode((Object)s);
        }
        this.encoder.close();
        fos.close();
    }

    List<String> decodeList(File file) throws IOException {
        String e;
        FileInputStream fis = new FileInputStream(file);
        this.eventStream = new EventObjectInputStream((InputStream)fis);
        ArrayList<String> back = new ArrayList<String>();
        while ((e = (String)this.eventStream.readEvent()) != null) {
            back.add(e);
        }
        return back;
    }

    @Test
    public void singleBatch() throws IOException {
        File file = new File(this.randomOutputDir + "x.lbo");
        ArrayList<String> witness = new ArrayList<String>();
        for (int i = 0; i < 10; ++i) {
            witness.add("hello" + i);
        }
        this.encodeList(file, witness);
        List<String> back = this.decodeList(file);
        Assert.assertEquals(witness, back);
    }

    @Test
    public void multipleBatches() throws IOException {
        File file = new File(this.randomOutputDir + "m.lbo");
        ArrayList<String> witness = new ArrayList<String>();
        for (int i = 0; i < 1000; ++i) {
            witness.add("hello" + i);
        }
        this.encodeList(file, witness);
        List<String> back = this.decodeList(file);
        Assert.assertEquals(witness, back);
    }
}

