/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.replay;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.SimpleConfigurator;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.action.NOPAction;
import ch.qos.logback.core.joran.replay.Fruit;
import ch.qos.logback.core.joran.replay.FruitContext;
import ch.qos.logback.core.joran.replay.FruitFactory;
import ch.qos.logback.core.joran.replay.FruitFactoryAction;
import ch.qos.logback.core.joran.replay.FruitShell;
import ch.qos.logback.core.joran.replay.FruitShellAction;
import ch.qos.logback.core.joran.replay.WeightytFruit;
import ch.qos.logback.core.joran.spi.ElementSelector;
import ch.qos.logback.core.util.StatusPrinter;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FruitConfigurationTest {
    FruitContext fruitContext = new FruitContext();

    public List<FruitShell> doFirstPart(String filename) throws Exception {
        try {
            HashMap<ElementSelector, Action> rulesMap = new HashMap<ElementSelector, Action>();
            rulesMap.put(new ElementSelector("group/fruitShell"), new FruitShellAction());
            rulesMap.put(new ElementSelector("group/fruitShell/fruit"), new FruitFactoryAction());
            rulesMap.put(new ElementSelector("group/fruitShell/fruit/*"), (Action)new NOPAction());
            SimpleConfigurator simpleConfigurator = new SimpleConfigurator(rulesMap);
            simpleConfigurator.setContext((Context)this.fruitContext);
            simpleConfigurator.doConfigure("src/test/input/joran/replay/" + filename);
            return this.fruitContext.getFruitShellList();
        }
        catch (Exception je) {
            StatusPrinter.print((Context)this.fruitContext);
            throw je;
        }
    }

    @Test
    public void fruit1() throws Exception {
        List<FruitShell> fsList = this.doFirstPart("fruit1.xml");
        Assert.assertNotNull(fsList);
        Assert.assertEquals((long)1L, (long)fsList.size());
        FruitShell fs0 = fsList.get(0);
        Assert.assertNotNull((Object)((Object)fs0));
        Assert.assertEquals((Object)"fs0", (Object)fs0.getName());
        Fruit fruit0 = fs0.fruitFactory.buildFruit();
        Assert.assertTrue((boolean)(fruit0 instanceof Fruit));
        Assert.assertEquals((Object)"blue", (Object)fruit0.getName());
    }

    @Test
    public void fruit2() throws Exception {
        List<FruitShell> fsList = this.doFirstPart("fruit2.xml");
        Assert.assertNotNull(fsList);
        Assert.assertEquals((long)2L, (long)fsList.size());
        FruitShell fs0 = fsList.get(0);
        Assert.assertNotNull((Object)((Object)fs0));
        Assert.assertEquals((Object)"fs0", (Object)fs0.getName());
        Fruit fruit0 = fs0.fruitFactory.buildFruit();
        Assert.assertTrue((boolean)(fruit0 instanceof Fruit));
        Assert.assertEquals((Object)"blue", (Object)fruit0.getName());
        FruitShell fs1 = fsList.get(1);
        Assert.assertNotNull((Object)((Object)fs1));
        Assert.assertEquals((Object)"fs1", (Object)fs1.getName());
        Fruit fruit1 = fs1.fruitFactory.buildFruit();
        Assert.assertTrue((boolean)(fruit1 instanceof WeightytFruit));
        Assert.assertEquals((Object)"orange", (Object)fruit1.getName());
        Assert.assertEquals((double)1.2, (double)((WeightytFruit)fruit1).getWeight(), (double)0.01);
    }

    @Test
    public void withSubst() throws Exception {
        List<FruitShell> fsList = this.doFirstPart("fruitWithSubst.xml");
        Assert.assertNotNull(fsList);
        Assert.assertEquals((long)1L, (long)fsList.size());
        FruitShell fs0 = fsList.get(0);
        Assert.assertNotNull((Object)((Object)fs0));
        Assert.assertEquals((Object)"fs0", (Object)fs0.getName());
        int oldCount = FruitFactory.count;
        Fruit fruit0 = fs0.fruitFactory.buildFruit();
        Assert.assertTrue((boolean)(fruit0 instanceof WeightytFruit));
        Assert.assertEquals((Object)("orange-" + oldCount), (Object)fruit0.getName());
        Assert.assertEquals((double)1.2, (double)((WeightytFruit)fruit0).getWeight(), (double)0.01);
    }
}

