/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.rolling.helper.DateTokenConverter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class DatePatternToRegexTest {
    static Calendar CAL_2009_08_3_NIGHT = Calendar.getInstance();
    static Calendar CAL_2009_08_3_MORNING = Calendar.getInstance();

    @BeforeClass
    public static void setUpCalendars() {
        CAL_2009_08_3_NIGHT.set(2009, 8, 3, 21, 57, 16);
        CAL_2009_08_3_NIGHT.set(14, 333);
        CAL_2009_08_3_MORNING.set(2009, 8, 3, 10, 24, 37);
        CAL_2009_08_3_MORNING.set(14, 333);
    }

    @Test
    public void ISO8601() {
        this.doTest("yyyy-MM-dd HH:mm:ss,SSS", CAL_2009_08_3_NIGHT);
    }

    @Test
    public void withQuotes() {
        this.doTest("yyyy-MM-dd'T'HH:mm:ss,SSS", CAL_2009_08_3_NIGHT);
    }

    @Test
    public void month() {
        this.doTest("yyyy-MMM-dd", CAL_2009_08_3_NIGHT);
        this.doTest("yyyy-MMMM-dd", CAL_2009_08_3_NIGHT);
    }

    @Test
    public void dot() {
        this.doTest("yyyy.MMM.dd", CAL_2009_08_3_NIGHT);
    }

    @Test
    public void timeZone() {
        this.doTest("yyyy-MMM-dd HH:mm:ss z", CAL_2009_08_3_NIGHT);
        this.doTest("yyyy-MMM-dd HH:mm:ss Z", CAL_2009_08_3_NIGHT);
    }

    @Test
    public void dayInWeek() {
        this.doTest("yyyy-MMM-E", CAL_2009_08_3_NIGHT);
        this.doTest("yyyy-MMM-EE", CAL_2009_08_3_NIGHT);
        this.doTest("yyyy-MMM-EEE", CAL_2009_08_3_NIGHT);
    }

    @Test
    public void amPm() {
        this.doTest("yyyy-MM-dd a", CAL_2009_08_3_NIGHT);
        this.doTest("yyyy-MM-dd a", CAL_2009_08_3_MORNING);
    }

    void doTest(String datePattern, Calendar calendar, boolean slashified) {
        SimpleDateFormat sdf = new SimpleDateFormat(datePattern);
        DateTokenConverter dtc = this.makeDTC(datePattern);
        this.verify(sdf, calendar, dtc, slashified);
    }

    void doTest(String datePattern, Calendar calendar) {
        this.doTest(datePattern, calendar, false);
    }

    void verify(SimpleDateFormat sdf, Calendar calendar, DateTokenConverter dtc, boolean slashified) {
        String expected = sdf.format(calendar.getTime());
        if (slashified) {
            expected = expected.replace('\\', '/');
        }
        String regex = dtc.toRegex();
        Assert.assertTrue((String)("[" + expected + "] does not match regex [" + regex + "]"), (boolean)expected.matches(regex));
    }

    private DateTokenConverter makeDTC(String datePattern) {
        DateTokenConverter dtc = new DateTokenConverter();
        ArrayList<String> optionList = new ArrayList<String>();
        optionList.add(datePattern);
        dtc.setOptionList(optionList);
        dtc.start();
        return dtc;
    }
}

