/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.spi.PropertyContainer;
import ch.qos.logback.core.util.OptionHelper;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class OptionHelperTest {
    String text = "Testing ${v1} variable substitution ${v2}";
    String expected = "Testing if variable substitution works";
    Context context = new ContextBase();
    Map<String, String> secondaryMap;

    @Before
    public void setUp() throws Exception {
        this.secondaryMap = new HashMap<String, String>();
    }

    @Test
    public void testLiteral() {
        String noSubst = "hello world";
        String result = OptionHelper.substVars((String)noSubst, (PropertyContainer)this.context);
        Assert.assertEquals((Object)noSubst, (Object)result);
    }

    @Test
    public void testUndefinedValues() {
        String withUndefinedValues = "${axyz}";
        String result = OptionHelper.substVars((String)withUndefinedValues, (PropertyContainer)this.context);
        Assert.assertEquals((Object)"axyz_IS_UNDEFINED", (Object)result);
    }

    @Test
    public void testSubstVarsVariableNotClosed() {
        String noSubst = "testing if ${v1 works";
        try {
            String result = OptionHelper.substVars((String)noSubst, (PropertyContainer)this.context);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSubstVarsContextOnly() {
        this.context.putProperty("v1", "if");
        this.context.putProperty("v2", "works");
        String result = OptionHelper.substVars((String)this.text, (PropertyContainer)this.context);
        Assert.assertEquals((Object)this.expected, (Object)result);
    }

    @Test
    public void testSubstVarsSystemProperties() {
        System.setProperty("v1", "if");
        System.setProperty("v2", "works");
        String result = OptionHelper.substVars((String)this.text, (PropertyContainer)this.context);
        Assert.assertEquals((Object)this.expected, (Object)result);
        System.clearProperty("v1");
        System.clearProperty("v2");
    }

    @Test
    public void testSubstVarsWithDefault() {
        this.context.putProperty("v1", "if");
        String textWithDefault = "Testing ${v1} variable substitution ${v2:-toto}";
        String resultWithDefault = "Testing if variable substitution toto";
        String result = OptionHelper.substVars((String)textWithDefault, (PropertyContainer)this.context);
        Assert.assertEquals((Object)resultWithDefault, (Object)result);
    }

    @Test
    public void testSubstVarsRecursive() {
        this.context.putProperty("v1", "if");
        this.context.putProperty("v2", "${v3}");
        this.context.putProperty("v3", "works");
        String result = OptionHelper.substVars((String)this.text, (PropertyContainer)this.context);
        Assert.assertEquals((Object)this.expected, (Object)result);
    }

    @Ignore
    @Test
    public void defaultValueReferencingAVariable() {
        this.context.putProperty("v1", "k1");
        String result = OptionHelper.substVars((String)"${undef:-${v1}}", (PropertyContainer)this.context);
        Assert.assertEquals((Object)"k1", (Object)result);
    }

    @Test
    public void jackrabbit_standalone() {
        String r = OptionHelper.substVars((String)"${jackrabbit.log:-${repo:-jackrabbit}/log/jackrabbit.log}", (PropertyContainer)this.context);
        Assert.assertEquals((Object)"jackrabbit/log/jackrabbit.log", (Object)r);
    }
}

