/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.event.stax;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.event.stax.BodyEvent;
import ch.qos.logback.core.joran.event.stax.StartEvent;
import ch.qos.logback.core.joran.event.stax.StaxEvent;
import ch.qos.logback.core.joran.event.stax.StaxEventRecorder;
import ch.qos.logback.core.status.StatusChecker;
import ch.qos.logback.core.status.StatusManager;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import javax.xml.stream.events.Attribute;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaxEventRecorderTest {
    Context context = new ContextBase();
    StatusChecker statusChecker = new StatusChecker(this.context);

    public List<StaxEvent> doTest(String filename) throws Exception {
        StaxEventRecorder recorder = new StaxEventRecorder(this.context);
        FileInputStream fis = new FileInputStream("src/test/input/joran/" + filename);
        recorder.recordEvents((InputStream)fis);
        return recorder.getEventList();
    }

    public void dump(List<StaxEvent> seList) {
        for (StaxEvent se : seList) {
            System.out.println(se);
        }
    }

    @Test
    public void testParsingOfXMLWithAttributesAndBodyText() throws Exception {
        List<StaxEvent> seList = this.doTest("event1.xml");
        Assert.assertTrue((this.statusChecker.getHighestLevel(0L) == 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)11L, (long)seList.size());
        Assert.assertEquals((Object)"test", (Object)seList.get(0).getName());
        Assert.assertEquals((Object)"badBegin", (Object)seList.get(1).getName());
        StartEvent startEvent = (StartEvent)seList.get(7);
        Assert.assertEquals((Object)"John Doe", (Object)startEvent.getAttributeByName("name").getValue());
        Assert.assertEquals((Object)"XXX&", (Object)((BodyEvent)seList.get(8)).getText());
    }

    @Test
    public void testProcessingOfTextWithEntityCharacters() throws Exception {
        List<StaxEvent> seList = this.doTest("ampEvent.xml");
        StatusManager sm = this.context.getStatusManager();
        Assert.assertTrue((this.statusChecker.getHighestLevel(0L) == 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)3L, (long)seList.size());
        BodyEvent be = (BodyEvent)seList.get(1);
        Assert.assertEquals((Object)"xxx & yyy", (Object)be.getText());
    }

    @Test
    public void testAttributeProcessing() throws Exception {
        List<StaxEvent> seList = this.doTest("inc.xml");
        StatusManager sm = this.context.getStatusManager();
        Assert.assertTrue((this.statusChecker.getHighestLevel(0L) == 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)4L, (long)seList.size());
        StartEvent se = (StartEvent)seList.get(1);
        Attribute attr = se.getAttributeByName("increment");
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((Object)"1", (Object)attr.getValue());
    }

    @Test
    public void bodyWithSpacesAndQuotes() throws Exception {
        List<StaxEvent> seList = this.doTest("spacesAndQuotes.xml");
        Assert.assertEquals((long)3L, (long)seList.size());
        BodyEvent be = (BodyEvent)seList.get(1);
        Assert.assertEquals((Object)"[x][x] \"xyz\"%n", (Object)be.getText());
    }
}

