/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.appender;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.appender.AbstractAppenderTest;
import ch.qos.logback.core.encoder.DummyEncoder;
import ch.qos.logback.core.encoder.NopEncoder;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusChecker;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.testUtil.RandomUtil;
import java.io.File;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class FileAppenderTest
extends AbstractAppenderTest<Object> {
    int diff = RandomUtil.getPositiveInt();

    @Override
    protected Appender<Object> getAppender() {
        return new FileAppender();
    }

    @Override
    protected Appender<Object> getConfiguredAppender() {
        FileAppender appender = new FileAppender();
        appender.setEncoder(new NopEncoder());
        appender.setFile("target/test-output/temp.log");
        appender.setName("test");
        appender.setContext(this.context);
        appender.start();
        return appender;
    }

    @Test
    public void smoke() {
        String filename = "target/test-output//fat-smoke.log";
        FileAppender appender = new FileAppender();
        appender.setEncoder(new DummyEncoder());
        appender.setAppend(false);
        appender.setFile(filename);
        appender.setName("smoke");
        appender.setContext(this.context);
        appender.start();
        appender.doAppend(new Object());
        appender.stop();
        File file = new File(filename);
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((String)("failed to delete " + file.getAbsolutePath()), (boolean)file.delete());
    }

    @Test
    public void testCreateParentFolders() {
        String filename = "target/test-output//fat-testCreateParentFolders-" + this.diff + "/testCreateParentFolders.txt";
        File file = new File(filename);
        Assert.assertFalse((boolean)file.getParentFile().exists());
        Assert.assertFalse((boolean)file.exists());
        FileAppender appender = new FileAppender();
        appender.setEncoder(new DummyEncoder());
        appender.setAppend(false);
        appender.setFile(filename);
        appender.setName("testCreateParentFolders");
        appender.setContext(this.context);
        appender.start();
        appender.doAppend(new Object());
        appender.stop();
        Assert.assertTrue((boolean)file.getParentFile().exists());
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((String)("failed to delete " + file.getAbsolutePath()), (boolean)file.delete());
        File parent = file.getParentFile();
        Assert.assertTrue((String)("failed to delete " + parent.getAbsolutePath()), (boolean)parent.delete());
    }

    @Test
    public void testPrudentModeLogicalImplications() {
        String filename = "target/test-output/" + this.diff + "fat-testPrudentModeLogicalImplications.txt";
        File file = new File(filename);
        FileAppender appender = new FileAppender();
        appender.setEncoder(new DummyEncoder());
        appender.setFile(filename);
        appender.setName("testPrudentModeLogicalImplications");
        appender.setContext(this.context);
        appender.setAppend(false);
        appender.setPrudent(true);
        appender.start();
        Assert.assertTrue((boolean)appender.isAppend());
        StatusManager sm = this.context.getStatusManager();
        StatusChecker statusChecker = new StatusChecker(this.context);
        Assert.assertEquals((long)1L, (long)statusChecker.getHighestLevel(0L));
        List statusList = sm.getCopyOfStatusList();
        Assert.assertTrue((String)("Expecting status list size to be 2 or larger, but was " + statusList.size()), (statusList.size() >= 2 ? 1 : 0) != 0);
        String msg1 = ((Status)statusList.get(1)).getMessage();
        Assert.assertTrue((String)("Got message [" + msg1 + "]"), (boolean)msg1.startsWith("Setting \"Append\" property"));
        appender.doAppend(new Object());
        appender.stop();
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((String)("failed to delete " + file.getAbsolutePath()), (boolean)file.delete());
    }
}

