/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.DefaultTimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.FileMatchFunction;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.ScaffoldingForRollingTests;
import ch.qos.logback.core.rolling.SizeAndTimeBasedFNATP;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.rolling.helper.RollingCalendar;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TimeBasedRollingWithArchiveRemoval_Test
extends ScaffoldingForRollingTests {
    String MONTHLY_DATE_PATTERN = "yyyy-MM";
    String MONTHLY_CRONOLOG_DATE_PATTERN = "yyyy/MM";
    final String DAILY_CRONOLOG_DATE_PATTERN = "yyyy/MM/dd";
    RollingFileAppender<Object> rfa = new RollingFileAppender();
    TimeBasedRollingPolicy<Object> tbrp = new TimeBasedRollingPolicy();
    TimeBasedFileNamingAndTriggeringPolicy<Object> tbfnatp = new DefaultTimeBasedFileNamingAndTriggeringPolicy();
    long MILLIS_IN_MINUTE = 60000L;
    long MILLIS_IN_HOUR = 60L * this.MILLIS_IN_MINUTE;
    long MILLIS_IN_DAY = 24L * this.MILLIS_IN_HOUR;
    long MILLIS_IN_MONTH = (long)(30.43684991666667 * (double)this.MILLIS_IN_DAY);
    int MONTHS_IN_YEAR = 12;
    int slashCount = 0;
    boolean DO_CLEAN_HISTORY_ON_START = true;
    boolean DO_NOT_CLEAN_HISTORY_ON_START = false;

    @Override
    @Before
    public void setUp() {
        super.setUp();
    }

    private int computeSlashCount(String datePattern) {
        if (datePattern == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < datePattern.length(); ++i) {
            char c = datePattern.charAt(i);
            if (c != '/') continue;
            ++count;
        }
        return count;
    }

    @Test
    public void monthlyRolloverOverManyPeriods() {
        this.slashCount = this.computeSlashCount(this.MONTHLY_CRONOLOG_DATE_PATTERN);
        int numPeriods = 40;
        int maxHistory = 2;
        String fileNamePattern = this.randomOutputDir + "/%d{" + this.MONTHLY_CRONOLOG_DATE_PATTERN + "}/clean.txt.zip";
        long startTime = this.currentTime;
        long endTime = this.logOverMultiplePeriodsContinuously(this.currentTime, fileNamePattern, this.MILLIS_IN_MONTH, maxHistory, numPeriods);
        System.out.println("randomOutputDir:" + this.randomOutputDir);
        System.out.println("start:" + startTime + ", end=" + endTime);
        int differenceInMonths = RollingCalendar.diffInMonths((long)startTime, (long)endTime);
        System.out.println("differenceInMonths:" + differenceInMonths);
        Calendar startTimeAsCalendar = Calendar.getInstance();
        startTimeAsCalendar.setTimeInMillis(startTime);
        int indexOfStartPeriod = startTimeAsCalendar.get(2);
        boolean withExtraFolder = this.extraFolder(differenceInMonths, this.MONTHS_IN_YEAR, indexOfStartPeriod, maxHistory);
        this.check(this.expectedCountWithFolders(maxHistory, withExtraFolder));
    }

    void generateDailyRollover(long now, int maxHistory, int simulatedNumberOfPeriods, int startInactivity, int numInactivityPeriods) {
        this.slashCount = this.computeSlashCount("yyyy-MM-dd");
        this.logOverMultiplePeriods(now, this.randomOutputDir + "clean-%d{" + "yyyy-MM-dd" + "}.txt", this.MILLIS_IN_DAY, maxHistory, simulatedNumberOfPeriods, startInactivity, numInactivityPeriods);
        this.check(this.expectedCountWithoutFoldersWithInactivity(maxHistory, simulatedNumberOfPeriods, startInactivity + numInactivityPeriods));
    }

    @Test
    public void basicDailyRollover() {
        int maxHistory = 20;
        int simulatedNumberOfPeriods = 60;
        int startInactivity = 0;
        int numInactivityPeriods = 0;
        this.generateDailyRollover(this.currentTime, maxHistory, simulatedNumberOfPeriods, startInactivity, numInactivityPeriods);
    }

    @Test
    public void dailyRollover15() {
        int maxHistory = 5;
        int simulatedNumberOfPeriods = 15;
        int startInactivity = 6;
        int numInactivityPeriods = 3;
        this.generateDailyRollover(this.currentTime, maxHistory, simulatedNumberOfPeriods, startInactivity, numInactivityPeriods);
    }

    @Test
    public void dailyRolloverWithInactivity70() {
        int maxHistory = 6;
        int simulatedNumberOfPeriods = 70;
        int startInactivity = 30;
        int numInactivityPeriods = 1;
        this.generateDailyRollover(this.currentTime, maxHistory, simulatedNumberOfPeriods, startInactivity, numInactivityPeriods);
    }

    @Test
    public void dailyRolloverWithInactivity10() {
        int maxHistory = 6;
        int simulatedNumberOfPeriods = 10;
        int startInactivity = 3;
        int numInactivityPeriods = 4;
        this.generateDailyRollover(this.currentTime, maxHistory, simulatedNumberOfPeriods, startInactivity, numInactivityPeriods);
    }

    @Test
    public void dailyRolloverWithSecondPhase() {
        this.slashCount = this.computeSlashCount("yyyy-MM-dd");
        int maxHistory = 5;
        long endTime = this.logOverMultiplePeriodsContinuously(this.currentTime, this.randomOutputDir + "clean-%d{" + "yyyy-MM-dd" + "}.txt", this.MILLIS_IN_DAY, maxHistory, maxHistory * 2);
        this.logOverMultiplePeriodsContinuously(endTime + this.MILLIS_IN_DAY * 10L, this.randomOutputDir + "clean-%d{" + "yyyy-MM-dd" + "}.txt", this.MILLIS_IN_DAY, maxHistory, maxHistory);
        this.check(this.expectedCountWithoutFolders(maxHistory));
    }

    @Test
    public void dailyCronologRollover() {
        this.slashCount = this.computeSlashCount("yyyy/MM/dd");
        this.logOverMultiplePeriodsContinuously(this.currentTime, this.randomOutputDir + "/%d{" + "yyyy/MM/dd" + "}/clean.txt.zip", this.MILLIS_IN_DAY, 8, 24);
        int expectedDirMin = 9 + this.slashCount;
        int expectDirMax = expectedDirMin + 1 + 1;
        this.expectedFileAndDirCount(9, expectedDirMin, expectDirMax);
    }

    @Test
    public void dailySizeBasedRollover() {
        SizeAndTimeBasedFNATP sizeAndTimeBasedFNATP = new SizeAndTimeBasedFNATP();
        sizeAndTimeBasedFNATP.setMaxFileSize("10000");
        this.tbfnatp = sizeAndTimeBasedFNATP;
        this.slashCount = this.computeSlashCount("yyyy-MM-dd");
        this.logOverMultiplePeriodsContinuously(this.currentTime, this.randomOutputDir + "/%d{" + "yyyy-MM-dd" + "}-clean.%i.zip", this.MILLIS_IN_DAY, 5, 20);
        this.checkPatternCompliance(6 + this.slashCount, "\\d{4}-\\d{2}-\\d{2}-clean(\\.\\d)(.zip)?");
    }

    @Test
    public void dailyChronologSizeBasedRollover() {
        SizeAndTimeBasedFNATP sizeAndTimeBasedFNATP = new SizeAndTimeBasedFNATP();
        sizeAndTimeBasedFNATP.setMaxFileSize("10000");
        this.tbfnatp = sizeAndTimeBasedFNATP;
        this.slashCount = 1;
        this.logOverMultiplePeriodsContinuously(this.currentTime, this.randomOutputDir + "/%d{" + "yyyy-MM-dd" + "}/clean.%i.zip", this.MILLIS_IN_DAY, 5, 20);
        this.checkDirPatternCompliance(6);
    }

    @Test
    public void dailyChronologSizeBasedRolloverWithSecondPhase() {
        SizeAndTimeBasedFNATP sizeAndTimeBasedFNATP = new SizeAndTimeBasedFNATP();
        sizeAndTimeBasedFNATP.setMaxFileSize("10000");
        this.tbfnatp = sizeAndTimeBasedFNATP;
        this.slashCount = 1;
        int maxHistory = 5;
        int simulatedNumberOfPeriods = maxHistory * 4;
        long endTime = this.logOverMultiplePeriodsContinuously(this.currentTime, this.randomOutputDir + "/%d{" + "yyyy-MM-dd" + "}/clean.%i", this.MILLIS_IN_DAY, maxHistory, 3);
        this.logOverMultiplePeriodsContinuously(endTime + this.MILLIS_IN_DAY * 7L, this.randomOutputDir + "/%d{" + "yyyy-MM-dd" + "}/clean.%i", this.MILLIS_IN_DAY, maxHistory, simulatedNumberOfPeriods);
        this.checkDirPatternCompliance(maxHistory + 1);
    }

    void logOncePeriod(long currentTime, String fileNamePattern, int maxHistory) {
        this.buildRollingFileAppender(currentTime, fileNamePattern, maxHistory, this.DO_CLEAN_HISTORY_ON_START);
        this.rfa.doAppend((Object)("Hello ----------------------------------------------------------" + new Date(currentTime)));
        this.rfa.stop();
    }

    @Test
    public void cleanHistoryOnStart() {
        long now = this.currentTime;
        String fileNamePattern = this.randomOutputDir + "clean-%d{" + "yyyy-MM-dd" + "}.txt";
        int maxHistory = 3;
        for (int i = 0; i <= 5; ++i) {
            this.logOncePeriod(now, fileNamePattern, maxHistory);
            now += this.MILLIS_IN_DAY;
        }
        StatusPrinter.print((Context)this.context);
        this.check(this.expectedCountWithoutFolders(maxHistory));
    }

    @Test
    public void cleanHistoryOnStartWithDayPattern() {
        long now = this.currentTime;
        String fileNamePattern = this.randomOutputDir + "clean-%d{dd}.txt";
        int maxHistory = 3;
        for (int i = 0; i <= 5; ++i) {
            this.logOncePeriod(now, fileNamePattern, maxHistory);
            now += this.MILLIS_IN_DAY;
        }
        StatusPrinter.print((Context)this.context);
        this.check(this.expectedCountWithoutFolders(maxHistory));
    }

    @Test
    public void cleanHistoryOnStartWithHourPattern() {
        long now = this.currentTime;
        String fileNamePattern = this.randomOutputDir + "clean-%d{HH}.txt";
        int maxHistory = 3;
        for (int i = 0; i <= 5; ++i) {
            this.logOncePeriod(now, fileNamePattern, maxHistory);
            now += this.MILLIS_IN_HOUR;
        }
        StatusPrinter.print((Context)this.context);
        this.check(this.expectedCountWithoutFolders(maxHistory));
    }

    int expectedCountWithoutFolders(int maxHistory) {
        return maxHistory + 1;
    }

    int expectedCountWithFolders(int maxHistory, boolean withExtraFolder) {
        int numLogFiles = maxHistory + 1;
        int numLogFilesAndFolders = numLogFiles * 2;
        int result = numLogFilesAndFolders + this.slashCount;
        if (withExtraFolder) {
            ++result;
        }
        return result;
    }

    void buildRollingFileAppender(long currentTime, String fileNamePattern, int maxHistory, boolean cleanHistoryOnStart) {
        this.rfa.setContext(this.context);
        this.rfa.setEncoder((Encoder)this.encoder);
        this.tbrp.setContext(this.context);
        this.tbrp.setFileNamePattern(fileNamePattern);
        this.tbrp.setMaxHistory(maxHistory);
        this.tbrp.setParent(this.rfa);
        this.tbrp.setCleanHistoryOnStart(cleanHistoryOnStart);
        this.tbrp.timeBasedFileNamingAndTriggeringPolicy = this.tbfnatp;
        this.tbrp.timeBasedFileNamingAndTriggeringPolicy.setCurrentTime(currentTime);
        this.tbrp.start();
        this.rfa.setRollingPolicy(this.tbrp);
        this.rfa.start();
    }

    long logOverMultiplePeriodsContinuously(long simulatedTime, String fileNamePattern, long periodDurationInMillis, int maxHistory, int simulatedNumberOfPeriods) {
        return this.logOverMultiplePeriods(simulatedTime, fileNamePattern, periodDurationInMillis, maxHistory, simulatedNumberOfPeriods, 0, 0);
    }

    long logOverMultiplePeriods(long simulatedTime, String fileNamePattern, long periodDurationInMillis, int maxHistory, int simulatedNumberOfPeriods, int startInactivity, int numInactivityPeriods) {
        this.buildRollingFileAppender(simulatedTime, fileNamePattern, maxHistory, this.DO_NOT_CLEAN_HISTORY_ON_START);
        int ticksPerPeriod = 512;
        int runLength = simulatedNumberOfPeriods * ticksPerPeriod;
        int startInactivityIndex = 1 + startInactivity * ticksPerPeriod;
        int endInactivityIndex = startInactivityIndex + numInactivityPeriods * ticksPerPeriod;
        long tickDuration = periodDurationInMillis / (long)ticksPerPeriod;
        for (int i = 0; i <= runLength; ++i) {
            if (i < startInactivityIndex || i > endInactivityIndex) {
                this.rfa.doAppend((Object)("Hello ----------------------------------------------------------" + i));
            }
            this.tbrp.timeBasedFileNamingAndTriggeringPolicy.setCurrentTime(this.addTime(this.tbrp.timeBasedFileNamingAndTriggeringPolicy.getCurrentTime(), tickDuration));
            this.add(this.tbrp.future);
            this.waitForJobsToComplete();
        }
        this.rfa.stop();
        return this.tbrp.timeBasedFileNamingAndTriggeringPolicy.getCurrentTime();
    }

    boolean extraFolder(int numPeriods, int periodsPerEra, int beginPeriod, int maxHistory) {
        int valueOfLastMonth = (beginPeriod + numPeriods) % periodsPerEra;
        return valueOfLastMonth < maxHistory;
    }

    long addTime(long time, long timeToWait) {
        return time + timeToWait;
    }

    void expectedFileAndDirCount(int expectedFileAndDirCount, int expectedDirCountMin, int expectedDirCountMax) {
        File dir = new File(this.randomOutputDir);
        ArrayList<File> fileList = new ArrayList<File>();
        this.findFilesInFolderRecursivelyByPatterMatch(dir, fileList, "clean");
        ArrayList<File> dirList = new ArrayList<File>();
        this.findAllFoldersInFolderRecursively(dir, dirList);
        String msg = "expectedDirCountMin=" + expectedDirCountMin + ", expectedDirCountMax=" + expectedDirCountMax + " actual value=" + dirList.size();
        Assert.assertTrue((String)msg, (expectedDirCountMin <= dirList.size() && dirList.size() <= expectedDirCountMax ? 1 : 0) != 0);
    }

    void check(int expectedCount) {
        File dir = new File(this.randomOutputDir);
        ArrayList<File> fileList = new ArrayList<File>();
        this.findAllDirsOrStringContainsFilesRecursively(dir, fileList, "clean");
        Assert.assertEquals((long)expectedCount, (long)fileList.size());
    }

    int expectedCountWithoutFoldersWithInactivity(int maxHistory, int totalPeriods, int endOfInactivity) {
        int availableHistory = totalPeriods + 1 - endOfInactivity;
        int actualHistory = Math.min(availableHistory, maxHistory + 1);
        return actualHistory;
    }

    void genericFindMatching(final FileMatchFunction matchFunc, File dir, List<File> fileList, final String pattern, boolean includeDirs) {
        if (dir.isDirectory()) {
            File[] matchArray;
            for (File f : matchArray = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || matchFunc.match(f, pattern);
                }
            })) {
                if (f.isDirectory()) {
                    if (includeDirs) {
                        fileList.add(f);
                    }
                    this.genericFindMatching(matchFunc, f, fileList, pattern, includeDirs);
                    continue;
                }
                fileList.add(f);
            }
        }
    }

    private void findAllFoldersInFolderRecursively(File dir, List<File> fileList) {
        FileMatchFunction alwaysFalse = new FileMatchFunction(){

            @Override
            public boolean match(File f, String pattern) {
                return false;
            }
        };
        this.genericFindMatching(alwaysFalse, dir, fileList, null, true);
    }

    private void findAllDirsOrStringContainsFilesRecursively(File dir, List<File> fileList, String pattern) {
        FileMatchFunction matchFunction = new FileMatchFunction(){

            @Override
            public boolean match(File f, String pattern) {
                return f.getName().contains(pattern);
            }
        };
        this.genericFindMatching(matchFunction, dir, fileList, pattern, true);
    }

    void findFilesInFolderRecursivelyByPatterMatch(File dir, List<File> fileList, String pattern) {
        FileMatchFunction matchByPattern = new FileMatchFunction(){

            @Override
            public boolean match(File f, String pattern) {
                return f.getName().matches(pattern);
            }
        };
        this.genericFindMatching(matchByPattern, dir, fileList, pattern, false);
    }

    Set<String> groupByClass(List<File> fileList, String regex) {
        Pattern p = Pattern.compile(regex);
        HashSet<String> set = new HashSet<String>();
        for (File f : fileList) {
            String n = f.getName();
            Matcher m = p.matcher(n);
            m.matches();
            int begin = m.start(1);
            String reduced = n.substring(0, begin);
            set.add(reduced);
        }
        return set;
    }

    void checkPatternCompliance(int expectedClassCount, String regex) {
        File dir = new File(this.randomOutputDir);
        ArrayList<File> fileList = new ArrayList<File>();
        this.findFilesInFolderRecursivelyByPatterMatch(dir, fileList, regex);
        Set<String> set = this.groupByClass(fileList, regex);
        Assert.assertEquals((long)expectedClassCount, (long)set.size());
    }

    void checkDirPatternCompliance(int expectedClassCount) {
        File dir = new File(this.randomOutputDir);
        ArrayList<File> fileList = new ArrayList<File>();
        this.findAllFoldersInFolderRecursively(dir, fileList);
        for (File f : fileList) {
            Assert.assertTrue((f.list().length >= 1 ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)expectedClassCount, (long)fileList.size());
    }
}

