/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.helper.PeriodicityType;
import ch.qos.logback.core.rolling.helper.RollingCalendar;
import java.util.Date;
import junit.framework.TestCase;

public class RollingCalendarTest
extends TestCase {
    public RollingCalendarTest(String arg0) {
        super(arg0);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testPeriodicity() {
        RollingCalendar rc = new RollingCalendar();
        RollingCalendarTest.assertEquals((Object)PeriodicityType.TOP_OF_SECOND, (Object)rc.computePeriodicityType("yyyy-MM-dd_HH_mm_ss"));
        rc = new RollingCalendar();
        RollingCalendarTest.assertEquals((Object)PeriodicityType.TOP_OF_MINUTE, (Object)rc.computePeriodicityType("yyyy-MM-dd_HH_mm"));
        rc = new RollingCalendar();
        RollingCalendarTest.assertEquals((Object)PeriodicityType.TOP_OF_HOUR, (Object)rc.computePeriodicityType("yyyy-MM-dd_HH"));
        rc = new RollingCalendar();
        RollingCalendarTest.assertEquals((Object)PeriodicityType.TOP_OF_DAY, (Object)rc.computePeriodicityType("yyyy-MM-dd"));
        rc = new RollingCalendar();
        RollingCalendarTest.assertEquals((Object)PeriodicityType.TOP_OF_MONTH, (Object)rc.computePeriodicityType("yyyy-MM"));
    }

    public void testVaryingNumberOfHourlyPeriods() {
        RollingCalendar rc = new RollingCalendar();
        rc.init("yyyy-MM-dd_HH");
        long MILLIS_IN_HOUR = 3600000L;
        for (int p = 100; p > -100; --p) {
            long now = 1223325293589L;
            Date result = rc.getRelativeDate(new Date(now), p);
            long expected = now - now % MILLIS_IN_HOUR + (long)p * MILLIS_IN_HOUR;
            RollingCalendarTest.assertEquals((long)expected, (long)result.getTime());
        }
    }

    public void testVaryingNumberOfDailyPeriods() {
        RollingCalendar rc = new RollingCalendar();
        rc.init("yyyy-MM-dd");
        long MILLIS_IN_DAY = 86400000L;
        for (int p = 20; p > -100; --p) {
            long now = 1223325293589L;
            Date nowDate = new Date(now);
            Date result = rc.getRelativeDate(nowDate, p);
            long offset = rc.getTimeZone().getRawOffset() + rc.getTimeZone().getDSTSavings();
            long origin = now - (now + offset) % 86400000L;
            long expected = origin + (long)p * 86400000L;
            RollingCalendarTest.assertEquals((String)("p=" + p), (long)expected, (long)result.getTime());
        }
    }
}

