/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.spi.DefaultNestedComponentRegistry;
import ch.qos.logback.core.joran.util.Door;
import ch.qos.logback.core.joran.util.House;
import ch.qos.logback.core.joran.util.HouseColor;
import ch.qos.logback.core.joran.util.LargeSwimmingPoolImpl;
import ch.qos.logback.core.joran.util.PropertySetter;
import ch.qos.logback.core.joran.util.SwimmingPoolImpl;
import ch.qos.logback.core.joran.util.Window;
import ch.qos.logback.core.joran.util.beans.BeanDescriptionCache;
import ch.qos.logback.core.spi.FilterReply;
import ch.qos.logback.core.status.StatusChecker;
import ch.qos.logback.core.util.AggregationType;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PropertySetterTest {
    DefaultNestedComponentRegistry defaultComponentRegistry = new DefaultNestedComponentRegistry();
    Context context = new ContextBase();
    House house = new House();
    PropertySetter setter = new PropertySetter(new BeanDescriptionCache(), (Object)this.house);

    @Before
    public void setUp() {
        this.setter.setContext(this.context);
    }

    @Test
    public void testCanAggregateComponent() {
        Assert.assertEquals((Object)AggregationType.AS_COMPLEX_PROPERTY, (Object)this.setter.computeAggregationType("door"));
        Assert.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)this.setter.computeAggregationType("count"));
        Assert.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)this.setter.computeAggregationType("Count"));
        Assert.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)this.setter.computeAggregationType("name"));
        Assert.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)this.setter.computeAggregationType("Name"));
        Assert.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)this.setter.computeAggregationType("Duration"));
        Assert.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)this.setter.computeAggregationType("fs"));
        Assert.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)this.setter.computeAggregationType("open"));
        Assert.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)this.setter.computeAggregationType("Open"));
        Assert.assertEquals((Object)AggregationType.AS_COMPLEX_PROPERTY_COLLECTION, (Object)this.setter.computeAggregationType("Window"));
        Assert.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY_COLLECTION, (Object)this.setter.computeAggregationType("adjective"));
        Assert.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)this.setter.computeAggregationType("filterReply"));
        Assert.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)this.setter.computeAggregationType("houseColor"));
        System.out.println();
    }

    @Test
    public void testSetProperty() {
        House house = new House();
        PropertySetter setter = new PropertySetter(new BeanDescriptionCache(), (Object)house);
        setter.setProperty("count", "10");
        setter.setProperty("temperature", "33.1");
        setter.setProperty("name", "jack");
        setter.setProperty("open", "true");
        Assert.assertEquals((long)10L, (long)house.getCount());
        Assert.assertEquals((double)33.1, (double)house.getTemperature(), (double)0.01);
        Assert.assertEquals((Object)"jack", (Object)house.getName());
        Assert.assertTrue((boolean)house.isOpen());
        house = new House();
        setter = new PropertySetter(new BeanDescriptionCache(), (Object)house);
        setter.setProperty("Count", "10");
        setter.setProperty("Name", "jack");
        setter.setProperty("Open", "true");
        Assert.assertEquals((long)10L, (long)house.getCount());
        Assert.assertEquals((Object)"jack", (Object)house.getName());
        Assert.assertTrue((boolean)house.isOpen());
    }

    @Test
    public void testSetCamelProperty() {
        this.setter.setProperty("camelCase", "trot");
        Assert.assertEquals((Object)"trot", (Object)this.house.getCamelCase());
        this.setter.setProperty("camelCase", "gh");
        Assert.assertEquals((Object)"gh", (Object)this.house.getCamelCase());
    }

    @Test
    public void testSetComplexProperty() {
        Door door = new Door();
        this.setter.setComplexProperty("door", (Object)door);
        Assert.assertEquals((Object)door, (Object)this.house.getDoor());
    }

    @Test
    public void testgetClassNameViaImplicitRules() {
        Class compClass = this.setter.getClassNameViaImplicitRules("door", AggregationType.AS_COMPLEX_PROPERTY, this.defaultComponentRegistry);
        Assert.assertEquals(Door.class, (Object)compClass);
    }

    @Test
    public void testgetComplexPropertyColleClassNameViaImplicitRules() {
        Class compClass = this.setter.getClassNameViaImplicitRules("window", AggregationType.AS_COMPLEX_PROPERTY_COLLECTION, this.defaultComponentRegistry);
        Assert.assertEquals(Window.class, (Object)compClass);
    }

    @Test
    public void testPropertyCollection() {
        this.setter.addBasicProperty("adjective", "nice");
        this.setter.addBasicProperty("adjective", "big");
        Assert.assertEquals((long)2L, (long)this.house.adjectiveList.size());
        Assert.assertEquals((Object)"nice", (Object)this.house.adjectiveList.get(0));
        Assert.assertEquals((Object)"big", (Object)this.house.adjectiveList.get(1));
    }

    @Test
    public void testComplexCollection() {
        Window w1 = new Window();
        w1.handle = 10;
        Window w2 = new Window();
        w2.handle = 20;
        this.setter.addComplexProperty("window", (Object)w1);
        this.setter.addComplexProperty("window", (Object)w2);
        Assert.assertEquals((long)2L, (long)this.house.windowList.size());
        Assert.assertEquals((long)10L, (long)this.house.windowList.get((int)0).handle);
        Assert.assertEquals((long)20L, (long)this.house.windowList.get((int)1).handle);
    }

    @Test
    public void testSetComplexWithCamelCaseName() {
        SwimmingPoolImpl pool = new SwimmingPoolImpl();
        this.setter.setComplexProperty("swimmingPool", (Object)pool);
        Assert.assertEquals((Object)pool, (Object)this.house.getSwimmingPool());
    }

    @Test
    public void testDuration() {
        this.setter.setProperty("duration", "1.4 seconds");
        Assert.assertEquals((long)1400L, (long)this.house.getDuration().getMilliseconds());
    }

    @Test
    public void testFileSize() {
        this.setter.setProperty("fs", "2 kb");
        Assert.assertEquals((long)2048L, (long)this.house.getFs().getSize());
    }

    @Test
    public void testFilterReply() {
        this.setter.setProperty("filterReply", "ACCEPT");
        Assert.assertEquals((Object)FilterReply.ACCEPT, (Object)this.house.getFilterReply());
    }

    @Test
    public void testEnum() {
        this.setter.setProperty("houseColor", "BLUE");
        Assert.assertEquals((Object)((Object)HouseColor.BLUE), (Object)((Object)this.house.getHouseColor()));
    }

    @Test
    public void testDefaultClassAnnonation() {
        Method relevantMethod = this.setter.getRelevantMethod("SwimmingPool", AggregationType.AS_COMPLEX_PROPERTY);
        Assert.assertNotNull((Object)relevantMethod);
        Class spClass = this.setter.getDefaultClassNameByAnnonation("SwimmingPool", relevantMethod);
        Assert.assertEquals(SwimmingPoolImpl.class, (Object)spClass);
        Class classViaImplicitRules = this.setter.getClassNameViaImplicitRules("SwimmingPool", AggregationType.AS_COMPLEX_PROPERTY, this.defaultComponentRegistry);
        Assert.assertEquals(SwimmingPoolImpl.class, (Object)classViaImplicitRules);
    }

    @Test
    public void testDefaultClassAnnotationForLists() {
        Method relevantMethod = this.setter.getRelevantMethod("LargeSwimmingPool", AggregationType.AS_COMPLEX_PROPERTY_COLLECTION);
        Assert.assertNotNull((Object)relevantMethod);
        Class spClass = this.setter.getDefaultClassNameByAnnonation("LargeSwimmingPool", relevantMethod);
        Assert.assertEquals(LargeSwimmingPoolImpl.class, (Object)spClass);
        Class classViaImplicitRules = this.setter.getClassNameViaImplicitRules("LargeSwimmingPool", AggregationType.AS_COMPLEX_PROPERTY_COLLECTION, this.defaultComponentRegistry);
        Assert.assertEquals(LargeSwimmingPoolImpl.class, (Object)classViaImplicitRules);
    }

    @Test
    public void charset() {
        this.setter.setProperty("charset", "UTF-8");
        Assert.assertEquals((Object)Charset.forName("UTF-8"), (Object)this.house.getCharset());
        this.house.setCharset(null);
        this.setter.setProperty("charset", "UTF");
        Assert.assertNull((Object)this.house.getCharset());
        StatusChecker checker = new StatusChecker(this.context);
        checker.containsException(UnsupportedCharsetException.class);
    }
}

