/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.conditional;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.conditional.Condition;
import ch.qos.logback.core.joran.conditional.PropertyEvalScriptBuilder;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.spi.PropertyContainer;
import ch.qos.logback.core.testUtil.RandomUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PropertyEvalScriptBuilderTest {
    Context context = new ContextBase();
    InterpretationContext localPropContainer = new InterpretationContext(this.context, null);
    PropertyEvalScriptBuilder pesb = new PropertyEvalScriptBuilder((PropertyContainer)this.localPropContainer);
    int diff = RandomUtil.getPositiveInt();
    String k = "ka" + this.diff;
    String v = "va";
    String containsScript = "p(\"" + this.k + "\").contains(\"" + this.v + "\")";
    String isNullScriptStr = "isNull(\"" + this.k + "\")";
    String isDefiedScriptStr = "isDefined(\"" + this.k + "\")";

    @Before
    public void setUp() {
        this.context.setName("c" + this.diff);
        this.pesb.setContext(this.context);
    }

    @After
    public void tearDown() {
        System.clearProperty(this.k);
    }

    void buildAndAssertTrue(String scriptStr) throws Exception {
        Condition condition = this.pesb.build(scriptStr);
        Assert.assertNotNull((Object)condition);
        Assert.assertTrue((boolean)condition.evaluate());
    }

    void buildAndAssertFalse(String scriptStr) throws Exception {
        Condition condition = this.pesb.build(scriptStr);
        Assert.assertNotNull((Object)condition);
        Assert.assertFalse((boolean)condition.evaluate());
    }

    @Test
    public void existingLocalPropertyShouldEvaluateToTrue() throws Exception {
        this.localPropContainer.addSubstitutionProperty(this.k, this.v);
        this.buildAndAssertTrue(this.containsScript);
    }

    @Test
    public void existingContextPropertyShouldEvaluateToTrue() throws Exception {
        this.context.putProperty(this.k, this.v);
        this.buildAndAssertTrue(this.containsScript);
    }

    @Test
    public void existingSystemPropertyShouldEvaluateToTrue() throws Exception {
        System.setProperty(this.k, this.v);
        this.buildAndAssertTrue(this.containsScript);
    }

    @Test
    public void isNullForExistingLocalProperty() throws Exception {
        this.localPropContainer.addSubstitutionProperty(this.k, this.v);
        this.buildAndAssertFalse(this.isNullScriptStr);
    }

    @Test
    public void isNullForExistingContextProperty() throws Exception {
        this.context.putProperty(this.k, this.v);
        this.buildAndAssertFalse(this.isNullScriptStr);
    }

    @Test
    public void isNullForExistingSystemProperty() throws Exception {
        System.setProperty(this.k, this.v);
        this.buildAndAssertFalse(this.isNullScriptStr);
    }

    @Test
    public void inexistentPropertyShouldEvaluateToFalse() throws Exception {
        this.buildAndAssertFalse(this.containsScript);
    }

    @Test
    public void isNullForInexistentPropertyShouldEvaluateToTrue() throws Exception {
        this.buildAndAssertTrue(this.isNullScriptStr);
    }

    public void isDefinedForIExistimgtPropertyShouldEvaluateToTrue() throws Exception {
        this.localPropContainer.addSubstitutionProperty(this.k, this.v);
        this.buildAndAssertTrue(this.isDefiedScriptStr);
    }

    @Test
    public void isDefinedForInexistentPropertyShouldEvaluateToTrue() throws Exception {
        this.buildAndAssertFalse(this.isDefiedScriptStr);
    }
}

