/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.joran.util.beans.BeanDescriptionCache;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.ModelFactoryMethod;
import ch.qos.logback.core.model.NamedComponentModel;
import ch.qos.logback.core.model.processor.AllowAllModelFilter;
import ch.qos.logback.core.model.processor.DenyAllModelFilter;
import ch.qos.logback.core.model.processor.ModelFiler;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.FilterReply;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;

public class DefaultProcessor
extends ContextAwareBase {
    final InterpretationContext interpretationContext;
    final HashMap<Class<? extends Model>, ModelFactoryMethod> modelClassToHandlerMap = new HashMap();
    final HashMap<Class<? extends Model>, ModelHandlerBase> modelClassToDependencyAnalyserMap = new HashMap();
    ModelFiler phaseOneFilter = new AllowAllModelFilter();
    ModelFiler phaseTwoFilter = new DenyAllModelFilter();
    static final int DENIED = -1;

    public DefaultProcessor(Context context, InterpretationContext interpretationContext) {
        this.setContext(context);
        this.interpretationContext = interpretationContext;
    }

    public void addHandler(Class<? extends Model> modelClass, ModelFactoryMethod modelFactoryMethod) {
        this.modelClassToHandlerMap.put(modelClass, modelFactoryMethod);
    }

    public void addAnalyser(Class<? extends Model> modelClass, ModelHandlerBase handler) {
        this.modelClassToDependencyAnalyserMap.put(modelClass, handler);
    }

    private void traversalLoop(TraverseMethod traverseMethod, Model model, ModelFiler modelfFilter, String phaseName) {
        int LIMIT = 3;
        int i = 0;
        while (i < LIMIT) {
            int handledModelCount = traverseMethod.traverse(model, modelfFilter);
            if (handledModelCount == 0) break;
            ++i;
        }
    }

    public void process(Model model) {
        if (model == null) {
            this.addError("Expecting non null model to process");
            return;
        }
        this.initialObjectPush();
        this.mainTraverse(model, this.getPhaseOneFilter());
        this.analyseDependencies(model);
        this.traversalLoop(this::secondPhaseTraverse, model, this.getPhaseTwoFilter(), "phase 2");
        this.addInfo("End of configuration.");
        this.finalObjectPop();
    }

    private void finalObjectPop() {
        this.interpretationContext.popObject();
    }

    private void initialObjectPush() {
        this.interpretationContext.pushObject(this.context);
    }

    public ModelFiler getPhaseOneFilter() {
        return this.phaseOneFilter;
    }

    public ModelFiler getPhaseTwoFilter() {
        return this.phaseTwoFilter;
    }

    public void setPhaseOneFilter(ModelFiler phaseOneFilter) {
        this.phaseOneFilter = phaseOneFilter;
    }

    public void setPhaseTwoFilter(ModelFiler phaseTwoFilter) {
        this.phaseTwoFilter = phaseTwoFilter;
    }

    protected void analyseDependencies(Model model) {
        ModelHandlerBase handler = this.modelClassToDependencyAnalyserMap.get(model.getClass());
        if (handler != null) {
            try {
                handler.handle(this.interpretationContext, model);
            }
            catch (ModelHandlerException e) {
                this.addError("Failed to traverse model " + model.getTag(), e);
            }
        }
        for (Model m : model.getSubModels()) {
            this.analyseDependencies(m);
        }
        if (handler != null) {
            try {
                handler.postHandle(this.interpretationContext, model);
            }
            catch (ModelHandlerException e) {
                this.addError("Failed to invole postHandle on model " + model.getTag(), e);
            }
        }
    }

    private ModelHandlerBase createHandler(Model model) {
        ModelFactoryMethod modelFactoryMethod = this.modelClassToHandlerMap.get(model.getClass());
        if (modelFactoryMethod == null) {
            this.addError("Can't handle model of type " + model.getClass() + "  with tag: " + model.getTag() + " at line " + model.getLineNumber());
            return null;
        }
        ModelHandlerBase handler = modelFactoryMethod.make(this.context, this.interpretationContext);
        if (handler == null) {
            return null;
        }
        if (!handler.isSupportedModelType(model)) {
            this.addWarn("Handler [" + handler.getClass() + "] does not support " + model.idString());
            return null;
        }
        return handler;
    }

    protected int mainTraverse(Model model, ModelFiler modelFiler) {
        FilterReply filterReply = modelFiler.decide(model);
        if (filterReply == FilterReply.DENY) {
            return -1;
        }
        int count = 0;
        try {
            ModelHandlerBase handler = null;
            if (model.isUnhandled() && (handler = this.createHandler(model)) != null) {
                handler.handle(this.interpretationContext, model);
                model.markAsHandled();
                ++count;
            }
            if (!model.isSkipped()) {
                for (Model m : model.getSubModels()) {
                    count += this.mainTraverse(m, modelFiler);
                }
            }
            if (handler != null) {
                handler.postHandle(this.interpretationContext, model);
            }
        }
        catch (ModelHandlerException e) {
            this.addError("Failed to traverse model " + model.getTag(), e);
        }
        return count;
    }

    protected int secondPhaseTraverse(Model model, ModelFiler modelFilter) {
        FilterReply filterReply = modelFilter.decide(model);
        if (filterReply == FilterReply.DENY) {
            return 0;
        }
        int count = 0;
        try {
            boolean allDependenciesStarted = this.allDependenciesStarted(model);
            ModelHandlerBase handler = null;
            if (model.isUnhandled() && allDependenciesStarted && (handler = this.createHandler(model)) != null) {
                handler.handle(this.interpretationContext, model);
                model.markAsHandled();
                ++count;
            }
            if (!allDependenciesStarted && !this.dependencyIsADirectSubmodel(model)) {
                return count;
            }
            if (!model.isSkipped()) {
                for (Model m : model.getSubModels()) {
                    count += this.secondPhaseTraverse(m, modelFilter);
                }
            }
            if (handler != null) {
                handler.postHandle(this.interpretationContext, model);
            }
        }
        catch (ModelHandlerException e) {
            this.addError("Failed to traverse model " + model.getTag(), e);
        }
        return count;
    }

    private boolean dependencyIsADirectSubmodel(Model model) {
        List<String> dependecyList = this.interpretationContext.getDependencies(model);
        if (dependecyList == null || dependecyList.isEmpty()) {
            return false;
        }
        for (Model submodel : model.getSubModels()) {
            NamedComponentModel namedComponentModel;
            String subModelName;
            if (!(submodel instanceof NamedComponentModel) || !dependecyList.contains(subModelName = (namedComponentModel = (NamedComponentModel)submodel).getName())) continue;
            return true;
        }
        return false;
    }

    private boolean allDependenciesStarted(Model model) {
        List<String> dependecyList = this.interpretationContext.getDependencies(model);
        if (dependecyList == null || dependecyList.isEmpty()) {
            return true;
        }
        for (String name : dependecyList) {
            boolean isStarted = this.interpretationContext.isNamedDependencyStarted(name);
            if (isStarted) continue;
            return isStarted;
        }
        return true;
    }

    ModelHandlerBase instantiateHandler(Class<? extends ModelHandlerBase> handlerClass) {
        try {
            Constructor<? extends ModelHandlerBase> commonConstructor = this.getWithContextConstructor(handlerClass);
            if (commonConstructor != null) {
                return commonConstructor.newInstance(this.context);
            }
            Constructor<? extends ModelHandlerBase> constructorWithBDC = this.getWithContextAndBDCConstructor(handlerClass);
            if (constructorWithBDC != null) {
                return constructorWithBDC.newInstance(this.context, this.interpretationContext.getBeanDescriptionCache());
            }
            this.addError("Failed to find suitable constructor for class [" + handlerClass + "]");
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e1) {
            this.addError("Failed to instantiate " + handlerClass);
            return null;
        }
    }

    private Constructor<? extends ModelHandlerBase> getWithContextConstructor(Class<? extends ModelHandlerBase> handlerClass) {
        try {
            Constructor<? extends ModelHandlerBase> constructor = handlerClass.getConstructor(Context.class);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private Constructor<? extends ModelHandlerBase> getWithContextAndBDCConstructor(Class<? extends ModelHandlerBase> handlerClass) {
        try {
            Constructor<? extends ModelHandlerBase> constructor = handlerClass.getConstructor(Context.class, BeanDescriptionCache.class);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    static interface TraverseMethod {
        public int traverse(Model var1, ModelFiler var2);
    }
}

