/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.action.DummyAttributes;
import ch.qos.logback.core.joran.action.PropertyAction;
import ch.qos.logback.core.joran.spi.ActionException;
import ch.qos.logback.core.joran.spi.SaxEventInterpretationContext;
import ch.qos.logback.core.joran.spi.SaxEventInterpreter;
import ch.qos.logback.core.model.ImplicitModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.PropertyModel;
import ch.qos.logback.core.model.TopModel;
import ch.qos.logback.core.model.processor.DefaultProcessor;
import ch.qos.logback.core.model.processor.ImplicitModelHandler;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.model.processor.NOPModelHandler;
import ch.qos.logback.core.model.processor.PropertyModelHandler;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.util.StatusPrinter;
import java.util.Iterator;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.xml.sax.Attributes;

public class PropertyActionTest {
    Context context;
    SaxEventInterpretationContext interpretationContext;
    ModelInterpretationContext mic;
    SaxEventInterpreter x;
    PropertyAction propertyAction;
    DummyAttributes atts = new DummyAttributes();
    DefaultProcessor defaultProcessor;
    TopModel topModel = new TopModel();
    String tagName = "property";

    @BeforeEach
    public void setUp() throws Exception {
        this.context = new ContextBase();
        this.interpretationContext = new SaxEventInterpretationContext(this.context, null);
        this.mic = new ModelInterpretationContext(this.context);
        this.topModel.setTag("top");
        this.interpretationContext.pushModel((Model)this.topModel);
        this.mic.pushModel((Model)this.topModel);
        this.propertyAction = new PropertyAction();
        this.propertyAction.setContext(this.context);
        this.defaultProcessor = new DefaultProcessor(this.context, this.mic);
        this.defaultProcessor.addHandler(TopModel.class, NOPModelHandler::makeInstance);
        this.defaultProcessor.addHandler(PropertyModel.class, PropertyModelHandler::makeInstance);
        this.defaultProcessor.addHandler(ImplicitModel.class, ImplicitModelHandler::makeInstance);
    }

    @AfterEach
    public void tearDown() throws Exception {
        StatusPrinter.print((Context)this.context);
        this.context = null;
        this.propertyAction = null;
        this.atts = null;
    }

    @Test
    public void nameValuePair() throws ActionException {
        this.atts.setValue("name", "v1");
        this.atts.setValue("value", "work");
        this.propertyAction.begin(this.interpretationContext, this.tagName, (Attributes)this.atts);
        this.propertyAction.end(this.interpretationContext, this.tagName);
        this.defaultProcessor.process((Model)this.topModel);
        Assertions.assertEquals((Object)"work", (Object)this.mic.getProperty("v1"));
    }

    @Test
    public void nameValuePairWithPrerequisiteSubsitution() throws ActionException {
        this.context.putProperty("w", "wor");
        this.atts.setValue("name", "v1");
        this.atts.setValue("value", "${w}k");
        this.propertyAction.begin(this.interpretationContext, this.tagName, (Attributes)this.atts);
        this.propertyAction.end(this.interpretationContext, this.tagName);
        this.defaultProcessor.process((Model)this.topModel);
        Assertions.assertEquals((Object)"work", (Object)this.mic.getProperty("v1"));
    }

    @Test
    public void noValue() throws ActionException {
        this.atts.setValue("name", "v1");
        this.propertyAction.begin(this.interpretationContext, this.tagName, (Attributes)this.atts);
        this.propertyAction.end(this.interpretationContext, this.tagName);
        this.defaultProcessor.process((Model)this.topModel);
        Assertions.assertEquals((int)2, (int)this.context.getStatusManager().getCount());
        Assertions.assertTrue((boolean)this.checkError());
    }

    @Test
    public void noName() throws ActionException {
        this.atts.setValue("value", "v1");
        this.propertyAction.begin(this.interpretationContext, this.tagName, (Attributes)this.atts);
        this.propertyAction.end(this.interpretationContext, this.tagName);
        this.defaultProcessor.process((Model)this.topModel);
        Assertions.assertEquals((int)2, (int)this.context.getStatusManager().getCount());
        Assertions.assertTrue((boolean)this.checkError());
    }

    @Test
    public void noAttributes() throws ActionException {
        this.propertyAction.begin(this.interpretationContext, "noAttributes", (Attributes)this.atts);
        this.propertyAction.end(this.interpretationContext, "noAttributes");
        this.defaultProcessor.process((Model)this.topModel);
        Assertions.assertEquals((int)2, (int)this.context.getStatusManager().getCount());
        Assertions.assertTrue((boolean)this.checkError());
        StatusPrinter.print((Context)this.context);
    }

    @Test
    public void testFileNotLoaded() throws ActionException {
        this.atts.setValue("file", "toto");
        this.atts.setValue("value", "work");
        this.propertyAction.begin(this.interpretationContext, this.tagName, (Attributes)this.atts);
        this.propertyAction.end(this.interpretationContext, this.tagName);
        this.defaultProcessor.process((Model)this.topModel);
        Assertions.assertEquals((int)2, (int)this.context.getStatusManager().getCount());
        Assertions.assertTrue((boolean)this.checkError());
    }

    @Test
    public void testLoadFileWithPrerequisiteSubsitution() throws ActionException {
        this.context.putProperty("STEM", "src/test/input/joran");
        this.atts.setValue("file", "${STEM}/propertyActionTest.properties");
        this.propertyAction.begin(this.interpretationContext, this.tagName, (Attributes)this.atts);
        this.propertyAction.end(this.interpretationContext, this.tagName);
        this.defaultProcessor.process((Model)this.topModel);
        Assertions.assertEquals((Object)"tata", (Object)this.mic.getProperty("v1"));
        Assertions.assertEquals((Object)"toto", (Object)this.mic.getProperty("v2"));
    }

    @Test
    public void testLoadFile() throws ActionException {
        this.atts.setValue("file", "src/test/input/joran/propertyActionTest.properties");
        this.propertyAction.begin(this.interpretationContext, this.tagName, (Attributes)this.atts);
        this.propertyAction.end(this.interpretationContext, this.tagName);
        this.defaultProcessor.process((Model)this.topModel);
        Assertions.assertEquals((Object)"tata", (Object)this.mic.getProperty("v1"));
        Assertions.assertEquals((Object)"toto", (Object)this.mic.getProperty("v2"));
    }

    @Test
    public void testLoadResource() throws ActionException {
        this.atts.setValue("resource", "asResource/joran/propertyActionTest.properties");
        this.propertyAction.begin(this.interpretationContext, this.tagName, (Attributes)this.atts);
        this.propertyAction.end(this.interpretationContext, this.tagName);
        this.defaultProcessor.process((Model)this.topModel);
        Assertions.assertEquals((Object)"tata", (Object)this.mic.getProperty("r1"));
        Assertions.assertEquals((Object)"toto", (Object)this.mic.getProperty("r2"));
    }

    @Test
    public void testLoadResourceWithPrerequisiteSubsitution() throws ActionException {
        this.context.putProperty("STEM", "asResource/joran");
        this.atts.setValue("resource", "${STEM}/propertyActionTest.properties");
        this.propertyAction.begin(this.interpretationContext, this.tagName, (Attributes)this.atts);
        this.propertyAction.end(this.interpretationContext, this.tagName);
        this.defaultProcessor.process((Model)this.topModel);
        Assertions.assertEquals((Object)"tata", (Object)this.mic.getProperty("r1"));
        Assertions.assertEquals((Object)"toto", (Object)this.mic.getProperty("r2"));
    }

    @Test
    public void testLoadNotPossible() throws ActionException {
        this.atts.setValue("file", "toto");
        this.propertyAction.begin(this.interpretationContext, this.tagName, (Attributes)this.atts);
        this.propertyAction.end(this.interpretationContext, this.tagName);
        this.defaultProcessor.process((Model)this.topModel);
        Assertions.assertEquals((int)2, (int)this.context.getStatusManager().getCount());
        Assertions.assertTrue((boolean)this.checkFileErrors());
    }

    private boolean checkError() {
        Iterator it = this.context.getStatusManager().getCopyOfStatusList().iterator();
        ErrorStatus es = (ErrorStatus)it.next();
        return "In <property> element, either the \"file\" attribute alone, or the \"resource\" element alone, or both the \"name\" and \"value\" attributes must be set.".equals(es.getMessage());
    }

    private boolean checkFileErrors() {
        Iterator it = this.context.getStatusManager().getCopyOfStatusList().iterator();
        ErrorStatus es1 = (ErrorStatus)it.next();
        return "Could not find properties file [toto].".equals(es1.getMessage());
    }
}

