/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net.ssl;

import ch.qos.logback.core.net.ssl.SecureRandomFactoryBean;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SecureRandomFactoryBeanTest {
    private SecureRandomFactoryBean factoryBean = new SecureRandomFactoryBean();

    @Test
    public void testDefaults() throws Exception {
        Assertions.assertNotNull((Object)this.factoryBean.createSecureRandom());
    }

    @Test
    public void testExplicitProvider() throws Exception {
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        this.factoryBean.setProvider(secureRandom.getProvider().getName());
        Assertions.assertNotNull((Object)this.factoryBean.createSecureRandom());
    }

    @Test
    public void testUnknownProvider() throws Exception {
        this.factoryBean.setProvider("A_FAKE_PROVIDER_NAME");
        try {
            this.factoryBean.createSecureRandom();
            Assertions.fail((String)"expected NoSuchProviderException");
        }
        catch (NoSuchProviderException ex) {
            Assertions.assertTrue((boolean)ex.getMessage().contains("A_FAKE_PROVIDER_NAME"));
        }
    }

    @Test
    public void testUnknownAlgorithm() throws Exception {
        this.factoryBean.setAlgorithm("A_FAKE_ALGORITHM_NAME");
        try {
            this.factoryBean.createSecureRandom();
            Assertions.fail((String)"expected NoSuchAlgorithmException");
        }
        catch (NoSuchAlgorithmException ex) {
            Assertions.assertTrue((boolean)ex.getMessage().contains("A_FAKE_ALGORITHM_NAME"));
        }
    }
}

