/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.testUtil.AbstractMultiThreadedHarness;
import ch.qos.logback.core.testUtil.RunnableWithCounterAndDone;
import ch.qos.logback.core.util.Duration;
import ch.qos.logback.core.util.InvocationGate;
import ch.qos.logback.core.util.SimpleInvocationGate;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class InvocationGateTest {
    private static final int ONCE_EVERY = 100;
    private static final int MAX_TRAVERSAL_COUNT = 10000;
    private static final int THREAD_COUNT = 16;
    static final int MASK = 2815;
    AtomicLong currentTime = new AtomicLong(1L);

    @Test
    public void smoke() {
        SimpleInvocationGate sig = new SimpleInvocationGate();
        long currentTime = SimpleInvocationGate.DEFAULT_INCREMENT.getMilliseconds() + 1L;
        Assertions.assertFalse((boolean)sig.isTooSoon(currentTime));
        Assertions.assertTrue((boolean)sig.isTooSoon(++currentTime));
    }

    @Disabled
    @Test
    void checkThreadSafety() throws InterruptedException {
        SimpleInvocationGate sig = new SimpleInvocationGate(Duration.buildByMilliseconds((double)1.0));
        long initialTime = this.currentTime.get();
        sig.isTooSoon(initialTime);
        AtomicInteger traversalCount = new AtomicInteger(0);
        RunnableWithCounterAndDone[] runnables = this.buildRunnables((InvocationGate)sig, traversalCount);
        SimpleInvocationGateHarness harness = new SimpleInvocationGateHarness(traversalCount);
        harness.execute(runnables);
        int tc = traversalCount.get();
        long ct = this.currentTime.get();
        long diff = ct - initialTime - 10000L;
        int traversalCountMismatch = tc - 10000;
        Assertions.assertTrue((traversalCountMismatch >= 0 ? 1 : 0) != 0, (String)"traversalCountMismatch must be a positive number");
        int tolerance = 6;
        Assertions.assertTrue((traversalCountMismatch < tolerance ? 1 : 0) != 0, (String)("traversalCountMismatch must be less than " + tolerance + " actual value " + traversalCountMismatch));
        Assertions.assertTrue((diff >= 0L ? 1 : 0) != 0, (String)"time difference must be a positive number");
        Assertions.assertTrue((diff < (long)tolerance ? 1 : 0) != 0, (String)("time difference must be less than " + tolerance + " actual value " + diff));
    }

    private RunnableWithCounterAndDone[] buildRunnables(InvocationGate invocationGate, AtomicInteger traversalCount) {
        RunnableWithCounterAndDone[] runnables = new RunnableWithCounterAndDone[17];
        runnables[0] = new TimeUpdater(this.currentTime);
        for (int i = 1; i < runnables.length; ++i) {
            runnables[i] = new InvocationGateChecker(invocationGate, traversalCount);
        }
        return runnables;
    }

    class SimpleInvocationGateHarness
    extends AbstractMultiThreadedHarness {
        AtomicInteger traversalCount;

        public SimpleInvocationGateHarness(AtomicInteger traversalCount) {
            this.traversalCount = traversalCount;
        }

        public void waitUntilEndCondition() throws InterruptedException {
            while (this.traversalCount.get() < 10000) {
                Thread.yield();
            }
        }
    }

    private class TimeUpdater
    extends RunnableWithCounterAndDone {
        Random random = new Random(69923259L);
        AtomicLong currentTime;

        public TimeUpdater(AtomicLong currentTime) {
            this.currentTime = currentTime;
        }

        public void run() {
            this.sleep(10);
            while (!this.isDone()) {
                long ct;
                if (0 == this.random.nextInt(100) && ((ct = this.currentTime.incrementAndGet()) & 0xAFFL) == 2815L) {
                    System.out.println("Time increment ct=" + ct);
                }
                Thread.yield();
            }
        }

        private void sleep(int duration) {
            try {
                Thread.sleep(duration);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class InvocationGateChecker
    extends RunnableWithCounterAndDone {
        InvocationGate invocationGate;
        AtomicInteger traversalCount;

        public InvocationGateChecker(InvocationGate invocationGate, AtomicInteger traversalCount) {
            this.invocationGate = invocationGate;
            this.traversalCount = traversalCount;
        }

        public void run() {
            while (!this.isDone()) {
                int tc;
                if (!this.invocationGate.isTooSoon(InvocationGateTest.this.currentTime.get()) && ((tc = this.traversalCount.incrementAndGet()) & 0xAFF) == 2815) {
                    System.out.println("traversalCount=" + tc);
                }
                Thread.yield();
            }
        }
    }
}

