/*
 * Decompiled with CFR 0.152.
 */
package chapters.appenders.socket;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.net.SocketAppender;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.slf4j.LoggerFactory;

public class SocketClient1 {
    static void usage(String msg) {
        System.err.println(msg);
        System.err.println("Usage: java " + SocketClient1.class.getName() + " hostname port\n" + "   hostname the name of the remote log server\n" + "   port (integer) the port number of the server\n");
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            SocketClient1.usage("Wrong number of arguments.");
        }
        String hostName = args[0];
        int port = Integer.parseInt(args[1]);
        SocketAppender socketAppender = new SocketAppender();
        socketAppender.setRemoteHost(hostName);
        socketAppender.setPort(port);
        socketAppender.setReconnectionDelay(10000);
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        socketAppender.setContext((Context)lc);
        socketAppender.start();
        Logger logger = (Logger)LoggerFactory.getLogger(SocketClient1.class);
        logger.addAppender((Appender)socketAppender);
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            System.out.println("Type a message to send to log server at " + hostName + ":" + port + ". Type 'q' to quit.");
            String s = reader.readLine();
            if (s.equals("q")) break;
            logger.debug(s);
        }
    }
}

