/*
 * Decompiled with CFR 0.152.
 */
package cn.com.vastbase.jdbc;

import cn.com.vastbase.jdbc.PgConnection;
import cn.com.vastbase.jdbc.PgPreparedStatement;
import cn.com.vastbase.util.GT;
import cn.com.vastbase.util.PSQLException;
import cn.com.vastbase.util.PSQLState;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class MySQLCmptPreparedStatement
extends PgPreparedStatement
implements PreparedStatement {
    MySQLCmptPreparedStatement(PgConnection connection, String sql, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        super(connection, sql, rsType, rsConcurrency, rsHoldability);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream value) throws SQLException {
        try {
            if (value == null) {
                this.setNull(parameterIndex, -2);
                return;
            }
            byte[] tmp = new byte[value.available()];
            int len = value.read(tmp);
            if (len == -1) {
                throw new SQLException("Failed to read the inputstream");
            }
            this.preparedParameters.setBinaryParameter(parameterIndex, tmp, 9779);
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream value, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw new PSQLException(GT.tr("Object is too large to send over the protocol.", new Object[0]), PSQLState.NUMERIC_CONSTANT_OUT_OF_RANGE);
        }
        this.setBinaryStream(parameterIndex, value, (int)length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream value, int length) throws SQLException {
        try {
            int len;
            if (value == null) {
                this.setNull(parameterIndex, -2);
                return;
            }
            int i = Math.min(value.available(), length);
            byte[] tmp = new byte[i];
            if (i > 0 && (len = value.read(tmp)) == -1) {
                throw new SQLException("Failed to read the inputstream");
            }
            this.preparedParameters.setBinaryParameter(parameterIndex, tmp, 9779);
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
    }
}

