/*
 * Decompiled with CFR 0.152.
 */
package cn.com.vastbase.log;

import cn.com.vastbase.log.Log;
import cn.com.vastbase.util.PSQLException;
import cn.com.vastbase.util.PSQLState;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;

public class LogFactory {
    public static Log getLogger(String className, String instanceName) throws SQLException {
        if (className == null) {
            throw new PSQLException("logger class name is null", PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (instanceName == null) {
            throw new PSQLException("logger instance name is null", PSQLState.INVALID_PARAMETER_VALUE);
        }
        try {
            Class<?> loggerClass = null;
            try {
                loggerClass = Class.forName(className);
            }
            catch (ClassNotFoundException en) {
                loggerClass = Class.forName(LogFactory.getPackageName(Log.class) + "." + className);
            }
            Constructor<?> constructor = loggerClass.getConstructor(String.class);
            return (Log)constructor.newInstance(instanceName);
        }
        catch (ClassNotFoundException cnfe) {
            throw new PSQLException("can't find class of logger '" + className + "'", PSQLState.INVALID_PARAMETER_VALUE, (Throwable)cnfe);
        }
        catch (NoSuchMethodException nsme) {
            throw new PSQLException("logger has no default constructor", PSQLState.INVALID_PARAMETER_VALUE, (Throwable)nsme);
        }
        catch (InstantiationException inste) {
            throw new PSQLException("can't instantiate logger class '" + className + "'", PSQLState.INVALID_PARAMETER_VALUE, (Throwable)inste);
        }
        catch (InvocationTargetException invoe) {
            throw new PSQLException("can't invoke target of logger class '" + className + "'", PSQLState.INVALID_PARAMETER_VALUE, (Throwable)invoe);
        }
        catch (IllegalAccessException ille) {
            throw new PSQLException("can't access constructor of logger class '" + className + "'", PSQLState.INVALID_PARAMETER_VALUE, (Throwable)ille);
        }
        catch (ClassCastException ce) {
            throw new PSQLException("can't cast to Log for logger class '" + className + "'", PSQLState.INVALID_PARAMETER_VALUE, (Throwable)ce);
        }
    }

    public static String getPackageName(Class<?> clazz) {
        String name = clazz.getName();
        int startIndex = name.lastIndexOf(46);
        if (startIndex > 0) {
            return name.substring(0, startIndex);
        }
        return "";
    }
}

