/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie;

import cn.dreampie.DbConfig;
import cn.dreampie.DbSource;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.internal.info.MigrationInfoDumper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFlywayMojo
extends AbstractMojo {
    private Log log = this.getLog();
    @Parameter(defaultValue="${project.build.directory}/src/main/resources/application.properties", required=true)
    private String config;
    @Parameter(defaultValue="filesystem:${project.build.directory}/db/migration/", required=true)
    private String location;
    @Parameter(defaultValue="false")
    private boolean skip;
    private DbConfig dbConfig;

    public void info() {
        this.dbConfig = new DbConfig(this.config);
        Map<String, Flyway> flywayMap = this.flyways();
        for (Flyway flyway : flywayMap.values()) {
            this.log.info((CharSequence)("\n" + MigrationInfoDumper.dumpToAsciiTable((MigrationInfo[])flyway.info().all())));
        }
    }

    public void init() {
        this.dbConfig = new DbConfig(this.config);
        this.log.info((CharSequence)"flyway init begin!");
        Map<String, Flyway> flywayMap = this.flyways();
        for (Flyway flyway : flywayMap.values()) {
            flyway.init();
        }
        this.log.info((CharSequence)"flyway init end!");
    }

    public void repair() {
        this.dbConfig = new DbConfig(this.config);
        this.log.info((CharSequence)"flyway repair begin!");
        Map<String, Flyway> flywayMap = this.flyways();
        for (Flyway flyway : flywayMap.values()) {
            flyway.repair();
        }
        this.log.info((CharSequence)"flyway repair end!");
    }

    public void validate() {
        this.dbConfig = new DbConfig(this.config);
        this.log.info((CharSequence)"flyway validate begin!");
        Map<String, Flyway> flywayMap = this.flyways();
        for (Flyway flyway : flywayMap.values()) {
            flyway.validate();
        }
        this.log.info((CharSequence)"flyway validate end!");
    }

    public void migrate() {
        this.dbConfig = new DbConfig(this.config);
        this.log.info((CharSequence)"flyway migrate begin!");
        List<String> dbNames = this.dbConfig.getAllDbNames();
        boolean dev = this.dbConfig.isDev();
        for (String dbName : dbNames) {
            boolean auto = this.dbConfig.migrateAuto(dbName);
            if (dev || auto) {
                this.migrateAutomatically(dbName);
                continue;
            }
            this.checkState(dbName);
        }
        this.log.info((CharSequence)"flyway migrate end!");
    }

    public void clean() {
        this.dbConfig = new DbConfig(this.config);
        this.log.info((CharSequence)"flyway clean begin!");
        Map<String, Flyway> flywayMap = this.flyways();
        for (Flyway flyway : flywayMap.values()) {
            flyway.clean();
        }
        this.log.info((CharSequence)"flyway clean end!");
    }

    private Map<String, Flyway> flyways() {
        HashMap flywayMap = Maps.newHashMap();
        Map<String, DbSource> dbSourceMap = this.dbConfig.getAllDbSources();
        DbSource dbSource = null;
        String migrationFilesLocation = null;
        Flyway flyway = null;
        for (String dbName : dbSourceMap.keySet()) {
            migrationFilesLocation = this.location + dbName;
            this.log.info((CharSequence)("location:" + migrationFilesLocation));
            dbSource = dbSourceMap.get(dbName);
            flyway = new Flyway();
            flyway.setDataSource(dbSource.url, dbSource.user, dbSource.password, new String[0]);
            flyway.setLocations(new String[]{migrationFilesLocation});
            if (this.dbConfig.isClean(dbName)) {
                flyway.setCleanOnValidationError(true);
            }
            if (this.dbConfig.initOnMigrate(dbName)) {
                flyway.setInitOnMigrate(true);
            }
            flywayMap.put(dbName, flyway);
        }
        return flywayMap;
    }

    private void migrateAutomatically(String dbName) {
        Map<String, Flyway> flywayMap = this.flyways();
        flywayMap.get(dbName).migrate();
    }

    private void cleanAutomatically(String dbName) {
        Map<String, Flyway> flywayMap = this.flyways();
        flywayMap.get(dbName).clean();
    }

    private void checkState(String dbName) {
        Map<String, Flyway> flywayMap = this.flyways();
        Object[] pendingMigrations = flywayMap.get(dbName).info().pending();
        if (pendingMigrations != null) {
            throw new RuntimeException(dbName + "-" + Arrays.toString(pendingMigrations));
        }
    }
}

