/*
 * Decompiled with CFR 0.152.
 */
package cn.xuyanwu.spring.file.storage.aspect;

import cn.xuyanwu.spring.file.storage.FileInfo;
import cn.xuyanwu.spring.file.storage.aspect.DownloadAspectChainCallback;
import cn.xuyanwu.spring.file.storage.aspect.FileStorageAspect;
import cn.xuyanwu.spring.file.storage.platform.FileStorage;
import java.io.InputStream;
import java.util.Iterator;
import java.util.function.Consumer;

public class DownloadAspectChain {
    private DownloadAspectChainCallback callback;
    private Iterator<FileStorageAspect> aspectIterator;

    public DownloadAspectChain(Iterable<FileStorageAspect> aspects, DownloadAspectChainCallback callback) {
        this.aspectIterator = aspects.iterator();
        this.callback = callback;
    }

    public void next(FileInfo fileInfo, FileStorage fileStorage, Consumer<InputStream> consumer) {
        if (this.aspectIterator.hasNext()) {
            this.aspectIterator.next().downloadAround(this, fileInfo, fileStorage, consumer);
        } else {
            this.callback.run(fileInfo, fileStorage, consumer);
        }
    }

    public DownloadAspectChainCallback getCallback() {
        return this.callback;
    }

    public Iterator<FileStorageAspect> getAspectIterator() {
        return this.aspectIterator;
    }

    public void setCallback(DownloadAspectChainCallback callback) {
        this.callback = callback;
    }

    public void setAspectIterator(Iterator<FileStorageAspect> aspectIterator) {
        this.aspectIterator = aspectIterator;
    }
}

