/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.hbase10.coprocessor;

import co.cask.tephra.Transaction;
import co.cask.tephra.TxConstants;
import co.cask.tephra.util.TxUtils;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.ScanType;

public class TransactionVisibilityFilter
extends FilterBase {
    private final Transaction tx;
    private final Map<ImmutableBytesWritable, Long> oldestTsByFamily;
    private final boolean allowEmptyValues;
    private final boolean clearDeletes;
    private final Filter cellFilter;
    private final ImmutableBytesWritable currentFamily = new ImmutableBytesWritable(HConstants.EMPTY_BYTE_ARRAY);
    private long currentOldestTs;
    private DeleteTracker deleteTracker = new DeleteTracker();

    public TransactionVisibilityFilter(Transaction tx, Map<byte[], Long> ttlByFamily, boolean allowEmptyValues, ScanType scanType) {
        this(tx, ttlByFamily, allowEmptyValues, scanType, null);
    }

    public TransactionVisibilityFilter(Transaction tx, Map<byte[], Long> ttlByFamily, boolean allowEmptyValues, ScanType scanType, @Nullable Filter cellFilter) {
        this.tx = tx;
        this.oldestTsByFamily = Maps.newTreeMap();
        for (Map.Entry<byte[], Long> ttlEntry : ttlByFamily.entrySet()) {
            long familyTTL = ttlEntry.getValue();
            this.oldestTsByFamily.put(new ImmutableBytesWritable(ttlEntry.getKey()), familyTTL <= 0L ? 0L : tx.getVisibilityUpperBound() - familyTTL * 1000000L);
        }
        this.allowEmptyValues = allowEmptyValues;
        this.clearDeletes = scanType == ScanType.COMPACT_DROP_DELETES || scanType == ScanType.USER_SCAN && tx.getVisibilityLevel() != Transaction.VisibilityLevel.SNAPSHOT_ALL;
        this.cellFilter = cellFilter;
    }

    public Filter.ReturnCode filterKeyValue(Cell cell) throws IOException {
        long kvTimestamp;
        if (!CellUtil.matchingFamily((Cell)cell, (byte[])this.currentFamily.get(), (int)this.currentFamily.getOffset(), (int)this.currentFamily.getLength())) {
            this.currentFamily.set(cell.getFamilyArray(), cell.getFamilyOffset(), (int)cell.getFamilyLength());
            Long familyOldestTs = this.oldestTsByFamily.get(this.currentFamily);
            this.currentOldestTs = familyOldestTs != null ? familyOldestTs : 0L;
            this.deleteTracker.reset();
        }
        if (TxUtils.getTimestampForTTL((long)(kvTimestamp = cell.getTimestamp())) < this.currentOldestTs) {
            return Filter.ReturnCode.NEXT_COL;
        }
        if (this.tx.isVisible(kvTimestamp)) {
            if (this.tx.getVisibilityLevel() == Transaction.VisibilityLevel.SNAPSHOT_ALL && this.tx.isCurrentWrite(kvTimestamp)) {
                return this.runSubFilter(Filter.ReturnCode.INCLUDE, cell);
            }
            if (DeleteTracker.isFamilyDelete(cell)) {
                this.deleteTracker.addFamilyDelete(cell);
                if (this.clearDeletes) {
                    return Filter.ReturnCode.NEXT_COL;
                }
                return this.runSubFilter(Filter.ReturnCode.INCLUDE_AND_NEXT_COL, cell);
            }
            if (this.deleteTracker.isDeleted(cell)) {
                return Filter.ReturnCode.NEXT_COL;
            }
            if (this.isColumnDelete(cell)) {
                if (this.clearDeletes) {
                    return Filter.ReturnCode.NEXT_COL;
                }
                return this.runSubFilter(Filter.ReturnCode.INCLUDE_AND_NEXT_COL, cell);
            }
            return this.runSubFilter(Filter.ReturnCode.INCLUDE_AND_NEXT_COL, cell);
        }
        return Filter.ReturnCode.SKIP;
    }

    private Filter.ReturnCode runSubFilter(Filter.ReturnCode txFilterCode, Cell cell) throws IOException {
        if (this.cellFilter != null) {
            Filter.ReturnCode subFilterCode = this.cellFilter.filterKeyValue(cell);
            return this.determineReturnCode(txFilterCode, subFilterCode);
        }
        return txFilterCode;
    }

    protected Filter.ReturnCode determineReturnCode(Filter.ReturnCode txFilterCode, Filter.ReturnCode subFilterCode) {
        switch (subFilterCode) {
            case INCLUDE: {
                return txFilterCode;
            }
            case INCLUDE_AND_NEXT_COL: {
                return Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
            }
            case SKIP: {
                return txFilterCode == Filter.ReturnCode.INCLUDE ? Filter.ReturnCode.SKIP : Filter.ReturnCode.NEXT_COL;
            }
        }
        return subFilterCode;
    }

    public boolean filterRow() throws IOException {
        if (this.cellFilter != null) {
            return this.cellFilter.filterRow();
        }
        return super.filterRow();
    }

    public Cell transformCell(Cell cell) throws IOException {
        if (this.tx.getVisibilityLevel() == Transaction.VisibilityLevel.SNAPSHOT_ALL) {
            if (DeleteTracker.isFamilyDelete(cell)) {
                return new KeyValue(CellUtil.cloneRow((Cell)cell), CellUtil.cloneFamily((Cell)cell), null, cell.getTimestamp(), KeyValue.Type.DeleteFamily);
            }
            if (this.isColumnDelete(cell)) {
                return new KeyValue(CellUtil.cloneRow((Cell)cell), CellUtil.cloneFamily((Cell)cell), CellUtil.cloneQualifier((Cell)cell), cell.getTimestamp(), KeyValue.Type.DeleteColumn);
            }
        }
        return cell;
    }

    public void reset() throws IOException {
        this.deleteTracker.reset();
        if (this.cellFilter != null) {
            this.cellFilter.reset();
        }
    }

    public boolean filterRowKey(byte[] buffer, int offset, int length) throws IOException {
        if (this.cellFilter != null) {
            return this.cellFilter.filterRowKey(buffer, offset, length);
        }
        return super.filterRowKey(buffer, offset, length);
    }

    public boolean filterAllRemaining() throws IOException {
        if (this.cellFilter != null) {
            return this.cellFilter.filterAllRemaining();
        }
        return super.filterAllRemaining();
    }

    public void filterRowCells(List<Cell> kvs) throws IOException {
        if (this.cellFilter != null) {
            this.cellFilter.filterRowCells(kvs);
        } else {
            super.filterRowCells(kvs);
        }
    }

    public boolean hasFilterRow() {
        if (this.cellFilter != null) {
            return this.cellFilter.hasFilterRow();
        }
        return super.hasFilterRow();
    }

    public KeyValue getNextKeyHint(KeyValue currentKV) throws IOException {
        if (this.cellFilter != null) {
            return this.cellFilter.getNextKeyHint(currentKV);
        }
        return super.getNextKeyHint(currentKV);
    }

    public Cell getNextCellHint(Cell currentKV) throws IOException {
        if (this.cellFilter != null) {
            return this.cellFilter.getNextCellHint(currentKV);
        }
        return super.getNextCellHint(currentKV);
    }

    public boolean isFamilyEssential(byte[] name) throws IOException {
        if (this.cellFilter != null) {
            return this.cellFilter.isFamilyEssential(name);
        }
        return super.isFamilyEssential(name);
    }

    public byte[] toByteArray() throws IOException {
        return super.toByteArray();
    }

    private boolean isColumnDelete(Cell cell) {
        return !TxUtils.isPreExistingVersion((long)cell.getTimestamp()) && cell.getValueLength() == 0 && !this.allowEmptyValues;
    }

    private static final class DeleteTracker {
        private long familyDeleteTs;

        private DeleteTracker() {
        }

        public static boolean isFamilyDelete(Cell cell) {
            return !TxUtils.isPreExistingVersion((long)cell.getTimestamp()) && CellUtil.matchingQualifier((Cell)cell, (byte[])TxConstants.FAMILY_DELETE_QUALIFIER) && CellUtil.matchingValue((Cell)cell, (byte[])HConstants.EMPTY_BYTE_ARRAY);
        }

        public void addFamilyDelete(Cell delete) {
            this.familyDeleteTs = delete.getTimestamp();
        }

        public boolean isDeleted(Cell cell) {
            return cell.getTimestamp() <= this.familyDeleteTs;
        }

        public void reset() {
            this.familyDeleteTs = 0L;
        }
    }
}

