/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *	http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package co.elastic.apm.android.sdk.attributes.resources;

import co.elastic.apm.android.sdk.attributes.AttributesVisitor;
import co.elastic.apm.android.sdk.internal.configuration.Configurations;
import co.elastic.apm.android.sdk.internal.configuration.impl.GeneralConfiguration;
import co.elastic.apm.android.sdk.internal.services.Service;
import co.elastic.apm.android.sdk.internal.services.ServiceManager;
import co.elastic.apm.android.sdk.internal.services.appinfo.AppInfoService;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.semconv.ResourceAttributes;

public class ServiceIdVisitor implements AttributesVisitor {

    @Override
    public void visit(AttributesBuilder builder) {
        GeneralConfiguration configuration = Configurations.get(GeneralConfiguration.class);
        builder.put(ResourceAttributes.SERVICE_NAME, configuration.getServiceName())
                .put(ResourceAttributes.SERVICE_VERSION, configuration.getServiceVersion())
                .put(AttributeKey.longKey("service.build"), getServiceBuild())
                .put(ResourceAttributes.DEPLOYMENT_ENVIRONMENT, configuration.getServiceEnvironment());
    }

    private int getServiceBuild() {
        return ServiceManager.get().<AppInfoService>getService(Service.Names.APP_INFO).getVersionCode();
    }
}
