/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *	http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package co.elastic.apm.android.sdk.internal.configuration.impl;

import co.elastic.apm.android.sdk.connectivity.Connectivity;
import co.elastic.apm.android.sdk.connectivity.ExportProtocol;
import co.elastic.apm.android.sdk.connectivity.auth.AuthConfiguration;
import co.elastic.apm.android.sdk.internal.configuration.Configuration;

public final class ConnectivityConfiguration extends Configuration {
    private final Connectivity connectivity;
    private final ExportProtocol exportProtocol;

    public ConnectivityConfiguration(Connectivity connectivity, ExportProtocol exportProtocol) {
        this.connectivity = connectivity;
        this.exportProtocol = exportProtocol;
    }

    public String getEndpoint() {
        return connectivity.endpoint();
    }

    public AuthConfiguration getAuthConfiguration() {
        return connectivity.authConfiguration();
    }

    public ExportProtocol getExportProtocol() {
        return exportProtocol;
    }
}
