/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.attach;

import co.elastic.apm.attach.ElasticAttachmentProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.bytebuddy.agent.ByteBuddyAgent;

public class ElasticApmAttacher {
    private static final String TEMP_PROPERTIES_FILE_KEY = "c";

    public static void attach() {
        ElasticApmAttacher.attach(ElasticApmAttacher.loadProperties("elasticapm.properties"));
    }

    public static void attach(String propertiesLocation) {
        ElasticApmAttacher.attach(ElasticApmAttacher.loadProperties(propertiesLocation));
    }

    private static Map<String, String> loadProperties(String propertiesLocation) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        Properties props = new Properties();
        try (InputStream resourceStream = ElasticApmAttacher.class.getClassLoader().getResourceAsStream(propertiesLocation);){
            if (resourceStream != null) {
                props.load(resourceStream);
                for (String propertyName : props.stringPropertyNames()) {
                    propertyMap.put(propertyName, props.getProperty(propertyName));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return propertyMap;
    }

    public static void attach(Map<String, String> configuration) {
        if (Boolean.getBoolean("ElasticApm.attached")) {
            return;
        }
        ElasticApmAttacher.attach(ByteBuddyAgent.ProcessProvider.ForCurrentVm.INSTANCE.resolve(), configuration);
    }

    static File createTempProperties(Map<String, String> configuration) {
        File tempFile = null;
        if (!configuration.isEmpty()) {
            Properties properties = new Properties();
            properties.putAll(configuration);
            String externalConfig = configuration.get("config_file");
            if (null != externalConfig) {
                try (FileInputStream stream = new FileInputStream(externalConfig);){
                    properties.load(stream);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                tempFile = File.createTempFile("elstcapm", ".tmp");
                try (FileOutputStream outputStream = new FileOutputStream(tempFile);){
                    properties.store(outputStream, null);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return tempFile;
    }

    public static void attach(String pid, Map<String, String> configuration) {
        ElasticApmAttacher.attach(pid, configuration, AgentJarFileHolder.INSTANCE.agentJarFile);
    }

    public static void attach(String pid, Map<String, String> configuration, File agentJarFile) {
        File tempFile = ElasticApmAttacher.createTempProperties(configuration);
        String agentArgs = tempFile == null ? null : "c=" + tempFile.getAbsolutePath();
        ByteBuddyAgent.attach((File)agentJarFile, (String)pid, agentArgs, (ByteBuddyAgent.AttachmentProvider)ElasticAttachmentProvider.get());
        if (tempFile != null && !tempFile.delete()) {
            tempFile.deleteOnExit();
        }
    }

    @Deprecated
    public static void attach(String pid, String agentArgs) {
        ByteBuddyAgent.attach((File)AgentJarFileHolder.INSTANCE.agentJarFile, (String)pid, (String)agentArgs, (ByteBuddyAgent.AttachmentProvider)ElasticAttachmentProvider.get());
    }

    public static File getBundledAgentJarFile() {
        return AgentJarFileHolder.INSTANCE.agentJarFile;
    }

    static String md5Hash(InputStream resourceAsStream) throws IOException, NoSuchAlgorithmException {
        try (InputStream agentJar = resourceAsStream;){
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[1024];
            DigestInputStream dis = new DigestInputStream(agentJar, md);
            while (dis.read(buffer) != -1) {
            }
            String string = String.format("%032x", new BigInteger(1, md.digest()));
            return string;
        }
    }

    static String md5Hash(String s) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(s.getBytes());
        return String.format("%032x", new BigInteger(1, md.digest()));
    }

    private static enum AgentJarFileHolder {
        INSTANCE;

        final File agentJarFile = AgentJarFileHolder.getAgentJarFile();

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static File getAgentJarFile() {
            try (InputStream agentJar = ElasticApmAttacher.class.getResourceAsStream("/elastic-apm-agent.jar");){
                File tempAgentJar;
                block25: {
                    if (agentJar == null) {
                        File file = null;
                        return file;
                    }
                    String hash = ElasticApmAttacher.md5Hash(ElasticApmAttacher.class.getResourceAsStream("/elastic-apm-agent.jar"));
                    String user = ElasticApmAttacher.md5Hash(System.getProperty("user.name"));
                    tempAgentJar = new File(System.getProperty("java.io.tmpdir"), String.format("elastic-apm-agent-%s-%s.jar", user, hash));
                    if (!tempAgentJar.exists()) {
                        try (FileOutputStream out = new FileOutputStream(tempAgentJar);){
                            FileChannel channel = out.getChannel();
                            try (FileLock ignored = channel.lock();){
                                if (tempAgentJar.length() == 0L) {
                                    int length;
                                    byte[] buffer = new byte[1024];
                                    while ((length = agentJar.read(buffer)) != -1) {
                                        out.write(buffer, 0, length);
                                    }
                                }
                                break block25;
                            }
                        }
                    }
                    if (!ElasticApmAttacher.md5Hash(new FileInputStream(tempAgentJar)).equals(hash)) {
                        throw new IllegalStateException("Invalid MD5 checksum of " + tempAgentJar + ". Please delete this file.");
                    }
                }
                File file = tempAgentJar;
                return file;
            }
            catch (IOException | NoSuchAlgorithmException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

